/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.network;

import aroma1997.core.Aroma1997Core;
import aroma1997.core.block.te.element.TileEntityElementBase;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.network.NetworkHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ClassUtils;

public enum EncodingType {
    NULL(Objects::isNull){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return null;
        }
    }
    ,
    BOOLEAN(Boolean.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeBoolean(((Boolean)o).booleanValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readBoolean();
        }
    }
    ,
    BYTE(Byte.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeByte((int)((Byte)o).byteValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readByte();
        }
    }
    ,
    SHORT(Short.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeShort((int)((Short)o).shortValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readShort();
        }
    }
    ,
    CHARACTER(Character.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeChar((int)((Character)o).charValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return Character.valueOf(buf.readChar());
        }
    }
    ,
    INTEGER(Integer.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeInt(((Integer)o).intValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readInt();
        }
    }
    ,
    LONG(Long.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeLong(((Long)o).longValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readLong();
        }
    }
    ,
    FLOAT(Float.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeFloat(((Float)o).floatValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }
    }
    ,
    DOUBLE(Double.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeDouble(((Double)o).doubleValue());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return buf.readDouble();
        }
    }
    ,
    CLASS(Class.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            Class clazz = (Class)o;
            buf.writeBoolean(clazz.isPrimitive());
            clazz = ClassUtils.primitiveToWrapper((Class)clazz);
            NetworkHelper.writeString(buf, clazz.getName());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            Class clazz;
            boolean isPrimitive = buf.readBoolean();
            try {
                clazz = Class.forName(NetworkHelper.readString(buf));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not decode class.", e);
            }
            if (isPrimitive) {
                clazz = ClassUtils.wrapperToPrimitive(clazz);
            }
            return clazz;
        }
    }
    ,
    ENUM(Enum.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            Enum e = (Enum)o;
            CLASS.encodeLocal(buf, e.getClass());
            buf.writeInt(e.ordinal());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            String className = NetworkHelper.readString(buf);
            Class clazz = (Class)CLASS.decodeLocal(buf);
            assert (clazz.isEnum());
            T[] values = clazz.getEnumConstants();
            int ordinal = buf.readInt();
            if (ordinal >= values.length) {
                throw new IllegalArgumentException("Could not decode network packet enum, because class " + className + " does not have enough enum fields: " + ordinal);
            }
            return (Enum)values[ordinal];
        }
    }
    ,
    ARRAY(obj -> obj.getClass().isArray()){

        @Override
        void encodeLocal(ByteBuf buf, Object array) {
            Class<?> contained = array.getClass().getComponentType();
            int length = Array.getLength(array);
            buf.writeInt(length);
            CLASS.encodeLocal(buf, contained);
            for (int i = 0; i < length; ++i) {
                12.encode(buf, Array.get(array, i));
            }
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            int i;
            final int length = buf.readInt();
            Class clazz = (Class)CLASS.decodeLocal(buf);
            final Object array = Array.newInstance(clazz, length);
            final Object[] tmp = new Object[length];
            boolean isLateResolver = false;
            for (i = 0; i < length; ++i) {
                tmp[i] = 12.decode(buf);
                if (!(tmp[i] instanceof ILateResolver)) continue;
                isLateResolver = true;
            }
            if (isLateResolver) {
                return new ILateResolver<Object>(){

                    @Override
                    public Object apply(Object o) {
                        for (int i = 0; i < length; ++i) {
                            Array.set(array, i, EncodingType.finishDecoding(tmp[i], Array.get(o, i)));
                        }
                        return array;
                    }
                };
            }
            for (i = 0; i < length; ++i) {
                Array.set(array, i, tmp[i]);
            }
            return array;
        }
    }
    ,
    STRING(String.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            NetworkHelper.writeString(buf, (String)o);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return NetworkHelper.readString(buf);
        }
    }
    ,
    COLLECTION(Collection.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            ARRAY.encodeLocal(buf, ((Collection)o).toArray());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            final Object[] o = (Object[])ARRAY.decodeLocal(buf);
            return new ILateResolver<Collection<?>>(){

                @Override
                public Collection<?> apply(Collection collection) {
                    for (int i = 0; i < o.length; ++i) {
                        if (!(o[i] instanceof ILateResolver)) continue;
                        o[i] = EncodingType.finishDecoding(o[i], null);
                    }
                    collection.clear();
                    collection.addAll(Arrays.asList(o));
                    return collection;
                }
            };
        }
    }
    ,
    BLOCK_POS(BlockPos.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            BlockPos pos = (BlockPos)o;
            buf.writeLong(pos.func_177986_g());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return BlockPos.func_177969_a((long)buf.readLong());
        }
    }
    ,
    CHUNK_POS(ChunkPos.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            ChunkPos pos = (ChunkPos)o;
            buf.writeInt(pos.field_77276_a);
            buf.writeInt(pos.field_77275_b);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return new ChunkPos(buf.readInt(), buf.readInt());
        }
    }
    ,
    RESOURCE_LOCATION(ResourceLocation.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            NetworkHelper.writeString(buf, o + "");
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return new ResourceLocation(NetworkHelper.readString(buf));
        }
    }
    ,
    REGISTRY(IForgeRegistryEntry.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            IForgeRegistryEntry entry = (IForgeRegistryEntry)o;
            CLASS.encodeLocal(buf, entry.getRegistryType());
            RESOURCE_LOCATION.encodeLocal(buf, entry.getRegistryName());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            Class clazz = (Class)CLASS.decodeLocal(buf);
            IForgeRegistry registry = GameRegistry.findRegistry((Class)clazz);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find appropriate registry for type " + clazz);
            }
            return registry.getValue((ResourceLocation)RESOURCE_LOCATION.decodeLocal(buf));
        }
    }
    ,
    WORLD(World.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            buf.writeInt(((World)o).field_73011_w.getDimension());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            final int dim = buf.readInt();
            return new ILateResolver<World>(){

                @Override
                public World apply(World world) {
                    return Aroma1997Core.proxy.getWorld(dim);
                }
            };
        }
    }
    ,
    TILE_ENTITY(TileEntity.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            TileEntity te = (TileEntity)o;
            WORLD.encodeLocal(buf, te.func_145831_w());
            BLOCK_POS.encodeLocal(buf, te.func_174877_v());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            final ILateResolver world = (ILateResolver)WORLD.decodeLocal(buf);
            if (world == null) {
                return null;
            }
            final BlockPos pos = (BlockPos)BLOCK_POS.decodeLocal(buf);
            return new ILateResolver<TileEntity>(){

                @Override
                public TileEntity apply(TileEntity tileEntity) {
                    return ((World)world.apply(null)).func_175625_s(pos);
                }
            };
        }
    }
    ,
    NBT(NBTTagCompound.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            try {
                ByteBufOutputStream bufOut = new ByteBufOutputStream(buf);
                DataOutputStream os = new DataOutputStream((OutputStream)bufOut);
                CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)o), (DataOutput)os);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            try {
                ByteBufInputStream bufIn = new ByteBufInputStream(buf);
                DataInputStream is = new DataInputStream((InputStream)bufIn);
                return CompressedStreamTools.func_152456_a((DataInput)is, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    ITEM_STACK(ItemStack.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = ((ItemStack)o).func_77955_b(nbt);
            NBT.encodeLocal(buf, nbt);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return new ItemStack((NBTTagCompound)NBT.decodeLocal(buf));
        }
    }
    ,
    FLUID(Fluid.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            NetworkHelper.writeString(buf, FluidRegistry.getFluidName((Fluid)((Fluid)o)));
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return FluidRegistry.getFluid((String)NetworkHelper.readString(buf));
        }
    }
    ,
    FLUID_STACK(FluidStack.class, false){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            FluidStack fs = (FluidStack)o;
            FLUID.encodeLocal(buf, fs.getFluid());
            buf.writeInt(fs.amount);
            NBT.encodeLocalOrNull(buf, fs.tag);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            return new FluidStack((Fluid)FLUID.decodeLocal(buf), buf.readInt(), (NBTTagCompound)NBT.decodeLocalOrNull(buf));
        }
    }
    ,
    FLUID_TANK(FluidTank.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            FluidTank tank = (FluidTank)o;
            FLUID_STACK.encodeLocalOrNull(buf, tank.getFluid());
            buf.writeInt(tank.getCapacity());
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            final FluidStack stack = (FluidStack)FLUID_STACK.decodeLocalOrNull(buf);
            final int capacity = buf.readInt();
            return new ILateResolver<FluidTank>(){

                @Override
                public FluidTank apply(FluidTank o) {
                    o.setCapacity(capacity);
                    o.setFluid(stack);
                    return o;
                }
            };
        }
    }
    ,
    BUF(ByteBuf.class, true){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            ByteBuf object = (ByteBuf)o;
            buf.writeInt(object.readableBytes());
            buf.writeBytes(object);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            int len = buf.readInt();
            ByteBuf tmpBuf = Unpooled.buffer((int)len);
            buf.readBytes(tmpBuf, len);
            return tmpBuf;
        }
    }
    ,
    INVENTORY_PART(o -> o instanceof InventoryPartBase || o instanceof TileEntityElementBase){

        @Override
        void encodeLocal(ByteBuf buf, Object o) {
            ByteBuf tmpBuf = Unpooled.buffer();
            NetworkHelper.encodeAllInClass(o, tmpBuf);
            BUF.encodeLocal(buf, tmpBuf);
        }

        @Override
        Object decodeLocal(ByteBuf buf) {
            final ByteBuf tmpBuf = (ByteBuf)BUF.decodeLocal(buf);
            return new ILateResolver<Object>(){

                @Override
                public Object apply(Object part) {
                    NetworkHelper.decodeAllInClass(part, tmpBuf);
                    return part;
                }
            };
        }
    };

    public static final EncodingType[] VALUES;
    private final Predicate<Object> matches;

    private <T> EncodingType(Class<T> clazz, boolean fuzzy) {
        this(obj -> fuzzy ? clazz.isInstance(obj) : clazz == obj.getClass());
    }

    private <T> EncodingType(Predicate<Object> matches) {
        this.matches = matches;
        if (this.ordinal() > 255) {
            throw new IllegalStateException("Too many network datatypes known. Please change value to a short.");
        }
    }

    abstract void encodeLocal(ByteBuf var1, Object var2);

    void encodeLocalOrNull(ByteBuf buf, Object o) {
        if (o == null) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            this.encodeLocal(buf, o);
        }
    }

    abstract Object decodeLocal(ByteBuf var1);

    Object decodeLocalOrNull(ByteBuf buf) {
        if (buf.readBoolean()) {
            return null;
        }
        return this.decodeLocal(buf);
    }

    public static void encode(ByteBuf buf, Object o) {
        for (EncodingType type : VALUES) {
            if (!type.matches.test(o)) continue;
            buf.writeByte(type.ordinal());
            type.encodeLocal(buf, o);
            return;
        }
        throw new IllegalArgumentException("Tried to encode " + o + " from class " + o.getClass() + ", but no EncodingType could be found.");
    }

    public static Object decode(ByteBuf buf) {
        return VALUES[buf.readByte() & 0xFF].decodeLocal(buf);
    }

    public static <T> T finishDecoding(Object decodedObject, T originalObject) {
        if (decodedObject instanceof ILateResolver) {
            return (T)((ILateResolver)decodedObject).apply(originalObject);
        }
        return (T)decodedObject;
    }

    static {
        VALUES = EncodingType.values();
    }

    private static interface ILateResolver<T>
    extends Function<T, T> {
    }
}

