/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.gui;

import java.util.ArrayList;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.inventory.ContainerShieldGenerator;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.util.NumberUtil;
import stevekung.mods.moreplanets.util.client.gui.GuiContainerMP;
import stevekung.mods.moreplanets.util.client.gui.GuiElementInfoRegionMP;

public class GuiShieldGenerator
extends GuiContainerMP {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/shield_generator.png");
    private final TileEntityShieldGenerator tile;
    private GuiElementInfoRegionMP electricInfoRegion;
    private GuiButton buttonEnable;
    private GuiButton buttonConfig;

    public GuiShieldGenerator(InventoryPlayer inventory, TileEntityShieldGenerator tile) {
        super(new ContainerShieldGenerator(inventory, tile));
        this.tile = tile;
        this.field_147000_g = 212;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 1: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_SWITCH_SHIELD_GENERATOR_GUI, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), this.tile.func_174877_v(), true));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegionMP((this.field_146294_l - this.field_146999_f) / 2 + 151, (this.field_146295_m - this.field_147000_g) / 2 + 77, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion = new GuiElementInfoRegionMP((this.field_146294_l - this.field_146999_f) / 2 + 156, (this.field_146295_m - this.field_147000_g) / 2 + 21, 8, 43, electricityDesc, this.field_146294_l, this.field_146295_m, this);
        this.infoRegions.add(this.electricInfoRegion);
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 - 76, this.field_146295_m / 2 - 6, 72, 20, !this.tile.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        this.buttonConfig = new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 6, 72, 20, GCCoreUtil.translate((String)"gui.button.config.name"));
        this.field_146292_n.add(this.buttonConfig);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        boolean half1;
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
        this.buttonEnable.field_146126_j = !this.tile.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        String owner = null;
        try {
            owner = this.tile.func_145831_w().func_152378_a(UUID.fromString(this.tile.ownerUUID)).func_70005_c_() + "'s ";
        }
        catch (Exception e) {
            owner = "";
        }
        boolean half = (float)this.tile.shieldCapacity < (float)this.tile.maxShieldCapacity / 1.25f;
        boolean bl = half1 = (float)this.tile.shieldCapacity < (float)this.tile.maxShieldCapacity / 4.0f;
        TextFormatting color = half1 ? TextFormatting.DARK_RED : (half ? TextFormatting.GOLD : TextFormatting.GREEN);
        ArrayList<String> list = new ArrayList<String>();
        int y = 24;
        list.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.tile.getStatus());
        list.add(GCCoreUtil.translate((String)"gui.status.shield_damage.name") + ": " + TextFormatting.GREEN + this.tile.shieldDamage);
        list.add(GCCoreUtil.translate((String)"gui.status.shield_size.name") + ": " + TextFormatting.GREEN + this.tile.maxShieldSize);
        list.add(GCCoreUtil.translate((String)"gui.status.shield_capacity.name") + ": " + color + NumberUtil.format(this.tile.shieldCapacity) + "/" + NumberUtil.format(this.tile.maxShieldCapacity));
        if (this.tile.shieldChargeCooldown > 0) {
            list.add(GCCoreUtil.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + TextFormatting.AQUA + this.tile.shieldChargeCooldown / 20);
        }
        for (String text : list) {
            this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - 80, y, 2536735);
            y += 10;
        }
        this.field_146289_q.func_78276_b(owner + this.tile.func_70005_c_(), 8, 10, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 90 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int width = (this.field_146294_l - this.field_146999_f) / 2;
        int height = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(width, height + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        int scale = this.tile.getScaledElecticalLevel(42);
        this.func_73729_b(width + 156, height + 64 - scale, 176, 42 - scale + 10, 8, scale);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(width + 154, height + 66, 176, 0, 11, 10);
        }
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
    }
}

