/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import stevekung.mods.moreplanets.util.MPLog;

public class ConfigManagerMP {
    public static Configuration config;
    public static String GENERAL;
    public static String DIMENSIONS;
    public static String GC_ADDON_COMPAT;
    public static String OTHERS;
    public static String startedPlanet;
    public static boolean enableDebug;
    public static boolean enableVersionChecker;
    public static boolean enableChangeLogInGame;
    public static boolean enableNightVisionEffect;
    public static boolean enableBlackHoleExplosion;
    public static boolean enableStartedPlanet;
    public static boolean use3DTorchItemModel;
    public static int idNetworkHandler;
    public static int idDimensionDiona;
    public static int idDimensionChalos;
    public static int idDimensionNibiru;
    public static int idDimensionFronos;
    public static int idBaseRocketSchematic;
    public static int idBaseSchematic;
    public static int idBaseRocketSchematicGui;
    public static int idBaseSchematicGui;
    public static boolean enableDescriptionInWaila;
    public static boolean enableTier4RocketSchematic;
    public static boolean enableTier5RocketSchematic;
    public static boolean enableTier6RocketSchematic;
    public static boolean enableTier4RocketRecipe;
    public static boolean enableTier5RocketRecipe;
    public static boolean enableTier6RocketRecipe;

    public static void init(File file) {
        config = new Configuration(file);
        ConfigManagerMP.syncConfig(true);
    }

    public static void syncConfig(boolean load) {
        try {
            if (!ConfigManagerMP.config.isChild && load) {
                config.load();
            }
            config.setCategoryPropertyOrder(GENERAL, ConfigManagerMP.addGeneralConfig());
            config.setCategoryPropertyOrder(DIMENSIONS, ConfigManagerMP.addDimensionIDConfig());
            config.setCategoryPropertyOrder(GC_ADDON_COMPAT, ConfigManagerMP.addGCAddonCompatConfig());
            config.setCategoryPropertyOrder(OTHERS, ConfigManagerMP.addOtherConfig());
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            MPLog.error("More Planets has a problem loading it's configuration");
        }
    }

    private static ArrayList<String> addGeneralConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = config.get(GENERAL, "Planet to Start", "planet.");
        prop.setComment("Put planet name that you would like to spawn (Also you need to enable started planet in the config). For example \"planet.nibiru\", \"moon.moon\", \"satellite.spacestation.overworld\" ");
        startedPlanet = prop.getString();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Started Planet", false);
        enableStartedPlanet = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Night Vision Effect while boss fight", false);
        enableNightVisionEffect = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Black Hole Explosion", true);
        enableBlackHoleExplosion = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Use 3D Item Model for Torch", true);
        prop.setRequiresMcRestart(true);
        use3DTorchItemModel = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Debug Logging", false);
        enableDebug = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Version Checker", true);
        prop.setRequiresMcRestart(true);
        enableVersionChecker = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Enable Change Log in Game", true);
        enableChangeLogInGame = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = config.get(GENERAL, "Network Handler ID", 2542);
        prop.setRequiresMcRestart(true);
        idNetworkHandler = prop.getInt();
        propOrder.add(prop.getName());
        return propOrder;
    }

    private static ArrayList<String> addDimensionIDConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = config.get(DIMENSIONS, "Diona Dimension ID", -2542);
        prop.setRequiresMcRestart(true);
        idDimensionDiona = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(DIMENSIONS, "Chalos Dimension ID", -2543);
        prop.setRequiresMcRestart(true);
        idDimensionChalos = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(DIMENSIONS, "Nibiru Dimension ID", -2544);
        prop.setRequiresMcRestart(true);
        idDimensionNibiru = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(DIMENSIONS, "Fronos Dimension ID", -2545);
        prop.setRequiresMcRestart(true);
        idDimensionFronos = prop.getInt();
        propOrder.add(prop.getName());
        return propOrder;
    }

    private static ArrayList<String> addGCAddonCompatConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = config.get(GC_ADDON_COMPAT, "Enable Tier 4 Rocket Schematic", true);
        enableTier4RocketSchematic = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = config.get(GC_ADDON_COMPAT, "Enable Tier 5 Rocket Schematic", true);
        enableTier5RocketSchematic = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = config.get(GC_ADDON_COMPAT, "Enable Tier 6 Rocket Schematic", true);
        enableTier6RocketSchematic = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = config.get(GC_ADDON_COMPAT, "Enable Tier 4 Rocket Recipe", true);
        enableTier4RocketRecipe = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = config.get(GC_ADDON_COMPAT, "Enable Tier 5 Rocket Recipe", true);
        enableTier5RocketRecipe = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = config.get(GC_ADDON_COMPAT, "Enable Tier 6 Rocket Recipe", true);
        enableTier6RocketRecipe = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        return propOrder;
    }

    private static ArrayList<String> addOtherConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = config.get(OTHERS, "Tier 4 Rocket Schematic ID", 800);
        idBaseRocketSchematic = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(OTHERS, "Base Schematic ID", 850);
        idBaseSchematic = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(OTHERS, "Tier 4 Rocket Schematic GUI ID", 500);
        idBaseRocketSchematicGui = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(OTHERS, "Base Schematic GUI ID", 550);
        idBaseSchematicGui = prop.getInt();
        propOrder.add(prop.getName());
        prop = config.get(OTHERS, "Enable Description in Waila Tooltip", true);
        enableDescriptionInWaila = prop.getBoolean();
        propOrder.add(prop.getName());
        return propOrder;
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        ConfigCategory configGeneral = config.getCategory(GENERAL);
        configGeneral.setComment(GCCoreUtil.translate((String)"gui.config.mp.general"));
        list.add((IConfigElement)new ConfigElement(configGeneral));
        ConfigCategory configDimension = config.getCategory(DIMENSIONS);
        configDimension.setComment(GCCoreUtil.translate((String)"gui.config.mp.dimension"));
        list.add((IConfigElement)new ConfigElement(configDimension));
        ConfigCategory configGCAddon = config.getCategory(GC_ADDON_COMPAT);
        configGCAddon.setComment(GCCoreUtil.translate((String)"gui.config.mp.gcaddon"));
        list.add((IConfigElement)new ConfigElement(configGCAddon));
        ConfigCategory configGUIs = config.getCategory(OTHERS);
        configGUIs.setComment(GCCoreUtil.translate((String)"gui.config.mp.other"));
        list.add((IConfigElement)new ConfigElement(configGUIs));
        return list;
    }

    static {
        GENERAL = "config_moreplanets_general";
        DIMENSIONS = "config_moreplanets_dimensions";
        GC_ADDON_COMPAT = "config_moreplanets_gc_addon_compat";
        OTHERS = "config_moreplanets_others";
    }
}

