/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.entity.IImmuneBlackHole;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.util.DamageSourceMP;
import stevekung.mods.moreplanets.util.EnumParticleTypesMP;

public class EntityBlackHole
extends Entity {
    private int lifeTick;
    private int spawnBlockRadiusTick;

    public EntityBlackHole(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityBlackHole(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, 0.0, 0.0, 0.0);
        int range = this.getRange();
        List entitiesAroundBH = this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range));
        for (Entity entity : entitiesAroundBH) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || entity instanceof IImmuneBlackHole && ((IImmuneBlackHole)entity).isImmune()) continue;
            double motionX = this.field_70165_t - entity.field_70165_t;
            double motionY = this.field_70163_u - entity.field_70163_u;
            double motionZ = this.field_70161_v - entity.field_70161_v;
            if (entity instanceof EntityItem || entity instanceof EntityFallingBlock) {
                motionY = this.field_70163_u - entity.field_70163_u + 0.5;
            }
            entity.field_70159_w = motionX * this.getPullSpeed();
            entity.field_70181_x = motionY * this.getPullSpeed();
            entity.field_70179_y = motionZ * this.getPullSpeed();
            List entityNearBH = this.field_70170_p.func_72872_a(entity.getClass(), new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u - 0.25, this.field_70161_v - 0.25, this.field_70165_t + 0.25, this.field_70163_u + 0.5, this.field_70161_v + 0.25));
            for (Entity near : entityNearBH) {
                if (near instanceof EntityLivingBase) {
                    ((EntityLivingBase)near).func_70690_d(new PotionEffect(MobEffects.field_76440_q, Short.MAX_VALUE, 0, false, false));
                }
                if (near instanceof EntityPlayer) {
                    near.func_70097_a(DamageSourceMP.BLACK_HOLE, 10.0f);
                }
                if (near instanceof EntityPlayer || near instanceof EntityBlackHole) continue;
                near.func_70106_y();
            }
        }
        if (this.lifeTick == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, MPSounds.BLACK_HOLE_CREATED, SoundCategory.AMBIENT, 2.0f, 1.0f);
        }
        if (this.lifeTick < this.getMaxLife()) {
            ++this.lifeTick;
        }
        if (this.lifeTick % 80 == 0 && this.spawnBlockRadiusTick < 15) {
            ++this.spawnBlockRadiusTick;
        }
        if (this.lifeTick % 20 == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, MPSounds.BLACK_HOLE_AMBIENT, SoundCategory.AMBIENT, 2.0f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.lifeTick == this.getMaxLife()) {
                this.func_70106_y();
                if (ConfigManagerMP.enableBlackHoleExplosion) {
                    this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0f, true);
                }
            }
            this.spawnFallingBlock();
        } else {
            for (int i = 0; i < 16; ++i) {
                double d0 = this.field_70165_t + (double)this.field_70146_Z.nextFloat();
                double d1 = this.field_70163_u - 0.5 + (double)this.field_70146_Z.nextFloat();
                double d2 = this.field_70161_v + (double)this.field_70146_Z.nextFloat();
                double d3 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                int j = this.field_70146_Z.nextInt(2) * 2 - 1;
                d0 = this.field_70165_t + 0.25 * (double)j;
                d3 = this.field_70146_Z.nextFloat() * 2.0f * (float)j;
                d2 = this.field_70161_v + 0.25 * (double)j;
                d5 = this.field_70146_Z.nextFloat() * 2.0f * (float)j;
                MorePlanetsCore.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    private void spawnFallingBlock() {
        int blockPosX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockPosY = MathHelper.func_76128_c((double)this.field_70163_u);
        int blockPosZ = MathHelper.func_76128_c((double)this.field_70161_v);
        int radius = 1 + this.spawnBlockRadiusTick;
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                    if (!(dist <= (double)radius)) continue;
                    BlockPos pos = new BlockPos(blockPosX + x, blockPosY + y, blockPosZ + z);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.getExtendedState(state, (IBlockAccess)this.field_70170_p, pos) != null && radius <= 15) {
                        this.field_70170_p.func_175698_g(pos);
                    }
                    if (block.isAir(state, (IBlockAccess)this.field_70170_p, pos) || block.getExtendedState(state, (IBlockAccess)this.field_70170_p, pos) != state) continue;
                    this.field_70170_p.func_175698_g(pos);
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_70170_p, (double)(blockPosX + x), (double)(blockPosY + y), (double)(blockPosZ + z), state);
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_145813_c = false;
                    fallingBlock.field_70181_x += 0.5;
                    fallingBlock.func_70012_b((double)(blockPosX + x) + 0.5, (double)(blockPosY + y), (double)(blockPosZ + z) + 0.5, 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)fallingBlock);
                }
            }
        }
    }

    public void func_70106_y() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, MPSounds.BLACK_HOLE_DESTROYED, SoundCategory.AMBIENT, 2.0f, 1.0f);
        super.func_70106_y();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.lifeTick = nbt.func_74762_e("LifeTick");
        this.spawnBlockRadiusTick = nbt.func_74762_e("SpawnBlockRadiusTick");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("LifeTick", this.lifeTick);
        nbt.func_74768_a("SpawnBlockRadiusTick", this.spawnBlockRadiusTick);
    }

    protected int getMaxLife() {
        return 6000;
    }

    protected int getRange() {
        return 64;
    }

    protected double getPullSpeed() {
        return 0.2;
    }
}

