/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.fronos.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.module.planets.fronos.entity.ai.EntityAIFaceTexture;
import stevekung.mods.moreplanets.module.planets.fronos.entity.ai.EntityAIFronosPanic;
import stevekung.mods.moreplanets.module.planets.fronos.entity.ai.EntityAIFronosTempt;
import stevekung.mods.moreplanets.module.planets.fronos.items.FronosItems;
import stevekung.mods.moreplanets.util.entity.ai.PathNavigateGroundMP;

public abstract class EntityFronosPet
extends EntityTameable {
    protected int timeUntilToDropItem;
    public int closeEyeTimer;
    public int panicTimer;
    public int hungryTimer;
    protected EntityAIFaceTexture aiTexture;
    protected EntityAIFronosPanic aiPanic;
    protected EntityAIFronosTempt aiTempt;

    public EntityFronosPet(World world) {
        super(world);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP((EntityLiving)this, world);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.closeEyeTimer = this.aiTexture.getTimer();
        this.panicTimer = this.aiPanic.getTimer();
        this.hungryTimer = this.aiTempt.getTimer();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.closeEyeTimer = Math.max(0, this.closeEyeTimer - 1);
            this.panicTimer = Math.max(0, this.panicTimer - 1);
            if (!this.aiTempt.func_75250_a()) {
                this.hungryTimer = Math.max(0, this.hungryTimer - 1);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getLayItem() != null && !this.func_70631_g_() && !this.field_70170_p.field_72995_K && --this.timeUntilToDropItem <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70099_a(this.getLayItem(), 1.0f);
            this.timeUntilToDropItem = this.field_70146_Z.nextInt(6000) + 2000;
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ItemLayTime")) {
            this.timeUntilToDropItem = nbt.func_74762_e("ItemLayTime");
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ItemLayTime", this.timeUntilToDropItem);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(MPSounds.FRONOS_MOB_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return MPSounds.FRONOS_MOB_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MPSounds.FRONOS_MOB_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MPSounds.FRONOS_MOB_DEATH;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == FronosBlocks.FRONOS_GRASS;
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() == FronosItems.FRONOS_FOOD && itemStack.func_77952_i() == 0;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean isTamedItem;
        ItemStack itemStack = player.func_184586_b(hand);
        boolean bl = isTamedItem = !itemStack.func_190926_b() && itemStack.func_77973_b() == FronosItems.FRONOS_FOOD && itemStack.func_77952_i() == 1;
        if (this.func_70909_n()) {
            if (isTamedItem) {
                this.func_70691_i(5.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                if (this.field_70911_d != null) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && this.field_70911_d != null) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
            }
        } else if (isTamedItem) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70606_j(20.0f);
                    this.field_70699_by.func_75499_g();
                    this.func_184754_b(player.func_110124_au());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.closeEyeTimer = 20;
        } else if (id == 11) {
            this.panicTimer = 30;
        } else if (id == 12) {
            this.hungryTimer = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        return false;
    }

    public boolean isCloseEye() {
        return this.closeEyeTimer > 0;
    }

    public boolean isHungry() {
        return this.hungryTimer > 0;
    }

    public boolean isPanic() {
        return this.panicTimer > 0;
    }

    protected abstract ItemStack getLayItem();
}

