/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.dimension;

import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPDimensions;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.items.capsule.CapsuleType;
import stevekung.mods.moreplanets.module.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.client.sky.CloudRendererNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.client.sky.SkyProviderNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.client.sky.WeatherRendererNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.BiomeProviderNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.ChunkGeneratorNibiru;
import stevekung.mods.moreplanets.util.dimension.WorldProviderMP;

public class WorldProviderNibiru
extends WorldProviderMP {
    @Override
    public Vector3 getFogColor() {
        float f = 0.55f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.6392157f * f), (double)(0.35686275f * f), (double)(0.17254902f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.7647059f * f), (double)(0.43137255f * f), (double)(0.19607843f * f));
    }

    @Override
    public boolean hasSunset() {
        return true;
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        IBlockState iblockstate;
        Biome biomegenbase = this.getBiomeForCoords(pos);
        float f = biomegenbase.func_180626_a(pos);
        if (f > 0.15f) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && this.field_76579_a.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (iblockstate = this.field_76579_a.func_180495_p(pos)) == NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P()) {
            boolean flag;
            if (!byWater) {
                return true;
            }
            boolean bl = flag = this.isWater(pos.func_177976_e()) && this.isWater(pos.func_177974_f()) && this.isWater(pos.func_177978_c()) && this.isWater(pos.func_177968_d());
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    private boolean isWater(BlockPos pos) {
        return this.field_76579_a.func_180495_p(pos).func_177230_c() == NibiruBlocks.INFECTED_WATER_FLUID_BLOCK;
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        Block block;
        Biome biomegenbase = this.getBiomeForCoords(pos);
        float f = biomegenbase.func_180626_a(pos);
        if (f > 0.15f) {
            return false;
        }
        if (!checkLight) {
            return true;
        }
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && this.field_76579_a.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (block = this.field_76579_a.func_180495_p(pos).func_177230_c()).isAir(this.field_76579_a.func_180495_p(pos), (IBlockAccess)this.field_76579_a, pos) && NibiruBlocks.INFECTED_SNOW_LAYER.func_176196_c(this.field_76579_a, pos);
    }

    public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public long getDayLength() {
        return 144000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 0.95f) {
            value = 0.95f;
        }
        return value * value * 0.35f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        value = 1.0f - value;
        value = (float)((double)value * (1.0 - (double)(this.field_76579_a.func_72867_j(partialTicks) * 6.0f) / 16.0));
        value = (float)((double)value * (1.0 - (double)(this.field_76579_a.func_72819_i(partialTicks) * 8.0f) / 16.0));
        return value * 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.25;
    }

    public float getGravity() {
        return 0.0125f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 6;
    }

    public float getFallDamageModifier() {
        return 1.0f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.NIBIRU;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return 1.5f;
        }
        return 0.5f;
    }

    @Override
    public float getArrowGravity() {
        return 0.0475f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        return 120;
    }

    @Override
    public void setup(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(DionaItems.TIER_5_ROCKET_SCHEMATIC, 1, 0));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(DionaItems.TIER_5_ROCKET_SCHEMATIC, 1, 1));
        player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE_PROTECTION, 36020, 0, true, true));
        stats.getExtendedInventory().func_70299_a(0, new ItemStack(GCItems.oxMask, 1, 0));
        stats.getExtendedInventory().func_70299_a(1, new ItemStack(GCItems.oxygenGear, 1, 0));
        stats.getExtendedInventory().func_70299_a(2, new ItemStack(GCItems.oxTankHeavy, 1, 0));
        stats.getExtendedInventory().func_70299_a(3, new ItemStack(GCItems.oxTankHeavy, 1, 0));
        stats.getExtendedInventory().func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
        stats.getExtendedInventory().func_70299_a(6, new ItemStack(VenusItems.thermalPaddingTier2, 1, 0));
        stats.getExtendedInventory().func_70299_a(7, new ItemStack(VenusItems.thermalPaddingTier2, 1, 1));
        stats.getExtendedInventory().func_70299_a(8, new ItemStack(VenusItems.thermalPaddingTier2, 1, 2));
        stats.getExtendedInventory().func_70299_a(9, new ItemStack(VenusItems.thermalPaddingTier2, 1, 3));
        stats.getExtendedInventory().func_70299_a(10, new ItemStack(VenusItems.basicItem, 1, 0));
        player.field_71071_by.func_70441_a(CapsuleType.getInfectedProtectionCapsule());
        player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
        player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderNibiru((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer(new CloudRendererNibiru());
    }

    @Override
    protected void renderWeather() {
        this.setWeatherRenderer(new WeatherRendererNibiru());
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)this.getCelestialBody());
        return BiomeProviderNibiru.class;
    }

    @Override
    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderNibiru(this.field_76579_a.func_72905_C());
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorNibiru(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.NIBIRU;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(NibiruBlocks.INFECTED_GRASS, NibiruBlocks.GREEN_VEIN_GRASS, NibiruBlocks.INFECTED_DIRT, NibiruBlocks.NIBIRU_BLOCK, NibiruBlocks.TERRASTONE);
    }
}

