/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.entity;

import java.util.Random;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.items.capsule.CapsuleType;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityInfectedZombie;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerFollowGolem;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerHarvestFarmland;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerInteract;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerLookAtTradePlayer;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerMate;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerPlay;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAINibiruVillagerTradePlayer;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.entity.ISpaceMob;
import stevekung.mods.moreplanets.util.entity.ai.PathNavigateGroundMP;

public class EntityNibiruVillager
extends EntityAgeable
implements IMerchant,
INpc,
IEntityBreathable,
ISpaceMob {
    private static DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityNibiruVillager.class, (DataSerializer)DataSerializers.field_187192_b);
    private int randomTickDivider;
    private boolean isMating;
    private boolean isPlaying;
    private Village villageObj;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private boolean isWillingToMate;
    private int wealth;
    private UUID lastBuyingPlayer;
    private boolean isLookingForHome;
    private boolean areAdditionalTasksSet;
    private InventoryBasic villagerInventory;
    private ITradeList[] farmerTradeList = new ITradeList[]{new EmeraldForItems(new ItemStack(NibiruItems.INFECTED_WHEAT), new PriceInfo(18, 22)), new EmeraldForItems(new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, 6), new PriceInfo(15, 19)), new ListItemForEmeralds(new ItemStack(Items.field_151025_P), new PriceInfo(-4, -2)), new EmeraldForItems(new ItemStack(NibiruBlocks.INFECTED_MELON_BLOCK), new PriceInfo(7, 12)), new ListItemForEmeralds(new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, 0), new PriceInfo(-5, -7)), new ListItemForEmeralds(new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, 4), new PriceInfo(-7, -9))};
    private ITradeList[] librarianTradeList = new ITradeList[]{new EmeraldForItems(new ItemStack(Items.field_151121_aF), new PriceInfo(24, 36)), new ListEnchantedBookForEmeralds(), new EmeraldForItems(new ItemStack(Items.field_151122_aG), new PriceInfo(8, 10)), new ListItemForEmeralds(new ItemStack(NibiruBlocks.NIBIRU_BOOKSHELF, 1, 0), new PriceInfo(3, 4)), new ListItemForEmeralds(new ItemStack(NibiruBlocks.NIBIRU_BOOKSHELF, 1, 1), new PriceInfo(3, 4)), new ListEnchantedBookForEmeralds(), new ListEnchantedBookForEmeralds()};
    private ITradeList[] medicTradeList = new ITradeList[]{new EmeraldForItems(new ItemStack(Items.field_151042_j), new PriceInfo(24, 32)), new EmeraldForItems(new ItemStack(GCItems.basicItem, 1, 4), new PriceInfo(8, 10)), new ListItemForEmeralds(CapsuleType.getInfectedProtectionCapsule(), new PriceInfo(4, 6), true), new ListItemForEmeralds(CapsuleType.getDarkEnergyProtectionCapsule(), new PriceInfo(4, 6), true)};

    public EntityNibiruVillager(World world) {
        this(world, 0);
    }

    public EntityNibiruVillager(World world, int professionId) {
        super(world);
        this.villagerInventory = new InventoryBasic("Items", false, 8);
        this.setProfession(professionId);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGroundMP)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityEvolvedZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityInfectedZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAINibiruVillagerTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAINibiruVillagerLookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAINibiruVillagerMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAINibiruVillagerFollowGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAINibiruVillagerInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.func_98053_h(true);
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() == MPPotions.INFECTED_SPORE ? false : super.func_70687_e(potion);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP((EntityLiving)this, world);
    }

    private void setAdditionalAItasks() {
        if (!this.areAdditionalTasksSet) {
            this.areAdditionalTasksSet = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINibiruVillagerPlay(this, 0.32));
            } else if (this.getProfession() == 0 || this.getProfession() == 3) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAINibiruVillagerHarvestFarmland(this, 0.6));
            }
        }
    }

    protected void func_175500_n() {
        if (this.getProfession() == 0 || this.getProfession() == 3) {
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINibiruVillagerHarvestFarmland(this, 0.6));
        }
        super.func_175500_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            this.field_70170_p.func_175714_ae().func_176060_a(blockpos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.func_175714_ae().func_176056_a(blockpos, 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.villageObj.func_180608_a();
                this.func_175449_a(blockpos1, (int)((float)this.villageObj.func_75568_b() * 1.0f));
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.villageObj.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.villageObj != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.villageObj.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemStack = player.func_184586_b(hand);
        boolean bl = flag = !itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151063_bx;
        if (!(flag || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (!(this.field_70170_p.field_72995_K || this.buyingList != null && this.buyingList.size() <= 0)) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            player.func_71029_a(StatList.field_188074_H);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Profession", this.getProfession());
        tagCompound.func_74768_a("Riches", this.wealth);
        tagCompound.func_74757_a("Willing", this.isWillingToMate);
        if (this.buyingList != null) {
            tagCompound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setProfession(tagCompund.func_74762_e("Profession"));
        this.wealth = tagCompund.func_74762_e("Riches");
        this.isWillingToMate = tagCompund.func_74767_n("Willing");
        if (tagCompund.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tagCompund.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList nbttaglist = tagCompund.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemStack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemStack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemStack);
        }
        this.func_98053_h(true);
        this.setAdditionalAItasks();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.villageObj != null && livingBase != null) {
            this.villageObj.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.villageObj.modifyPlayerReputation(livingBase.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.villageObj != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.villageObj.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.villageObj.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.villageObj.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.isWillingToMate = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (!itemStack.func_190926_b()) {
                this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public ITextComponent func_145748_c_() {
        String s = this.func_95999_t();
        if (s != null && s.length() > 0) {
            TextComponentString chatcomponenttext = new TextComponentString(s);
            chatcomponenttext.func_150256_b().func_150209_a(this.func_174823_aP());
            chatcomponenttext.func_150256_b().func_179989_a(this.func_110124_au().toString());
            return chatcomponenttext;
        }
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        String name = null;
        switch (this.getProfession()) {
            case 0: 
            case 3: {
                name = "farmer";
                break;
            }
            case 1: 
            case 4: {
                name = "librarian";
                break;
            }
            case 2: 
            case 5: {
                name = "medic";
            }
        }
        if (name != null) {
            TextComponentTranslation chatcomponenttranslation = new TextComponentTranslation("entity.nibiru_villager." + name, new Object[0]);
            chatcomponenttranslation.func_150256_b().func_150209_a(this.func_174823_aP());
            chatcomponenttranslation.func_150256_b().func_179989_a(this.func_110124_au().toString());
            return chatcomponenttranslation;
        }
        return super.func_145748_c_();
    }

    public float func_70047_e() {
        float f = 1.62f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        if (this.field_70170_p.func_180494_b(this.func_180425_c()) == MPBiomes.GREEN_VEIN) {
            this.setProfession(3 + this.field_70146_Z.nextInt(3));
        } else {
            this.setProfession(this.field_70146_Z.nextInt(3));
        }
        this.setAdditionalAItasks();
        return super.func_180482_a(difficulty, data);
    }

    public void setLookingForHome() {
        this.isLookingForHome = true;
    }

    public EntityNibiruVillager createChild(EntityAgeable ageable) {
        EntityNibiruVillager entityvillager = new EntityNibiruVillager(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    public boolean canBreath() {
        return true;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityEvolvedWitch entitywitch = new EntityEvolvedWitch(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), (IEntityLivingData)null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_96094_a(this.func_95999_t());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        if (this.canVillagerPickupItem(itemStack)) {
            ItemStack itemstack1 = this.villagerInventory.func_174894_a(itemStack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemStack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStack) {
        if (super.func_174820_d(inventorySlot, itemStack)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStack);
            return true;
        }
        return false;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public void setProfession(int professionId) {
        this.field_70180_af.func_187227_b(PROFESSION, (Object)professionId);
    }

    public int getProfession() {
        return Math.max((Integer)this.field_70180_af.func_187225_a(PROFESSION) % 6, 0);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        if (!this.isWillingToMate && updateFirst && this.func_175553_cp()) {
            boolean flag = false;
            for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.villagerInventory.func_70301_a(i);
                if (!itemStack.func_190926_b()) {
                    if (itemStack.func_77973_b() == Items.field_151025_P && itemStack.func_190916_E() >= 3) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 3);
                    } else if (itemStack.func_77973_b() == NibiruItems.NIBIRU_FRUITS && itemStack.func_77952_i() == 6 && itemStack.func_190916_E() >= 12) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.isWillingToMate = true;
                break;
            }
        }
        return this.isWillingToMate;
    }

    public void setIsWillingToMate(boolean willingToTrade) {
        this.isWillingToMate = willingToTrade;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    private void populateBuyingList() {
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if (this.getProfession() == 0 || this.getProfession() == 3) {
            for (ITradeList tradeList : this.farmerTradeList) {
                tradeList.modifyMerchantRecipeList(this.buyingList, this.field_70146_Z);
            }
        }
        if (this.getProfession() == 1 || this.getProfession() == 4) {
            for (ITradeList tradeList : this.librarianTradeList) {
                tradeList.modifyMerchantRecipeList(this.buyingList, this.field_70146_Z);
            }
        }
        if (this.getProfession() == 2 || this.getProfession() == 5) {
            for (ITradeList tradeList : this.medicTradeList) {
                tradeList.modifyMerchantRecipeList(this.buyingList, this.field_70146_Z);
            }
        }
    }

    public InventoryBasic getVillagerInventory() {
        return this.villagerInventory;
    }

    private boolean canVillagerPickupItem(ItemStack itemStack) {
        return itemStack.func_77973_b() == NibiruItems.NIBIRU_FRUITS && itemStack.func_77952_i() == 6 || itemStack.func_77973_b() == NibiruItems.INFECTED_WHEAT || itemStack.func_77973_b() == NibiruItems.INFECTED_WHEAT_SEEDS;
    }

    private boolean func_175553_cp() {
        return this.hasEnoughItems(1);
    }

    public boolean canAbondonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean func_175557_cr() {
        boolean flag;
        boolean bl = flag = this.getProfession() == 0 || this.getProfession() == 3;
        return flag ? !this.hasEnoughItems(5) : !this.hasEnoughItems(1);
    }

    private boolean hasEnoughItems(int multiplier) {
        boolean flag = this.getProfession() == 0 || this.getProfession() == 3;
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.villagerInventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == Items.field_151025_P && itemStack.func_190916_E() >= 3 * multiplier || itemStack.func_77973_b() == NibiruItems.NIBIRU_FRUITS && itemStack.func_77952_i() == 6 && itemStack.func_190916_E() >= 12 * multiplier) {
                return true;
            }
            if (!flag || itemStack.func_77973_b() != NibiruItems.INFECTED_WHEAT || itemStack.func_190916_E() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    public boolean isFarmItemInInventory() {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.villagerInventory.func_70301_a(i);
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != NibiruItems.INFECTED_WHEAT && (itemStack.func_77973_b() != NibiruItems.NIBIRU_FRUITS || itemStack.func_77952_i() != 6)) continue;
            return true;
        }
        return false;
    }

    private static class PriceInfo
    extends Tuple<Integer, Integer> {
        public PriceInfo(int min, int max) {
            super((Object)min, (Object)max);
        }

        public int getPrice(Random rand) {
            return (Integer)this.func_76341_a() >= (Integer)this.func_76340_b() ? (Integer)this.func_76341_a() : (Integer)this.func_76341_a() + rand.nextInt((Integer)this.func_76340_b() - (Integer)this.func_76341_a() + 1);
        }
    }

    private static class ListItemForEmeralds
    implements ITradeList {
        private ItemStack buyStack;
        private PriceInfo price;
        private boolean isCapsule;

        public ListItemForEmeralds(ItemStack buyStack, PriceInfo price) {
            this.buyStack = buyStack;
            this.price = price;
        }

        public ListItemForEmeralds(ItemStack buyStack, PriceInfo price, boolean isCapsule) {
            this.buyStack = buyStack;
            this.price = price;
            this.isCapsule = isCapsule;
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random rand) {
            ItemStack sellItem;
            ItemStack buyItem;
            int i = 1;
            if (this.price != null) {
                i = this.price.getPrice(rand);
            }
            if (this.isCapsule) {
                ItemStack capsule = this.buyStack;
                if (i < 0) {
                    buyItem = new ItemStack(Items.field_151166_bC, 1, 0);
                    capsule.func_190920_e(1 + rand.nextInt(4));
                    sellItem = capsule;
                } else {
                    buyItem = new ItemStack(Items.field_151166_bC, i, 0);
                    capsule.func_190920_e(1 + rand.nextInt(4));
                    sellItem = capsule;
                }
            } else if (i < 0) {
                buyItem = new ItemStack(Items.field_151166_bC, 1, 0);
                sellItem = new ItemStack(this.buyStack.func_77973_b(), -i, this.buyStack.func_77960_j());
            } else {
                buyItem = new ItemStack(Items.field_151166_bC, i, 0);
                sellItem = new ItemStack(this.buyStack.func_77973_b(), 1, this.buyStack.func_77960_j());
            }
            recipeList.add((Object)new MerchantRecipe(buyItem, sellItem));
        }
    }

    private static class ListEnchantedBookForEmeralds
    implements ITradeList {
        private ListEnchantedBookForEmeralds() {
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random rand) {
            Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(rand);
            int i = MathHelper.func_76136_a((Random)rand, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + rand.nextInt(5 + i * 10) + 3 * i;
            if (j > 64) {
                j = 64;
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, j), itemstack));
        }
    }

    private static interface ITradeList {
        public void modifyMerchantRecipeList(MerchantRecipeList var1, Random var2);
    }

    private static class EmeraldForItems
    implements ITradeList {
        private ItemStack stackSell;
        private PriceInfo price;

        public EmeraldForItems(ItemStack stackSell, PriceInfo price) {
            this.stackSell = stackSell;
            this.price = price;
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random rand) {
            int i = 1;
            if (this.price != null) {
                i = this.price.getPrice(rand);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.stackSell.func_77973_b(), i, this.stackSell.func_77952_i()), Items.field_151166_bC));
        }
    }
}

