/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNibiruTallGrass;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.ai.EntityAIShlimeEatGrass;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.entity.ISpaceMob;
import stevekung.mods.moreplanets.util.entity.ai.EntityAITemptMP;
import stevekung.mods.moreplanets.util.entity.ai.PathNavigateGroundMP;

public class EntityShlime
extends EntityAnimal
implements IShearable,
ISpaceMob,
IEntityBreathable {
    private static DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityShlime.class, (DataSerializer)DataSerializers.field_187191_a);
    private InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }
    }, 2, 1);
    private int jumpTicks = 0;
    private int jumpDuration = 0;
    private boolean wasJumping = false;
    private boolean wasOnGround = false;
    private int currentMoveTypeDuration = 0;
    private EnumMoveType moveType = EnumMoveType.HOP;
    private int sheepTimer;
    private EntityAIShlimeEatGrass entityAIEatGrass = new EntityAIShlimeEatGrass((EntityLiving)this);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;

    public EntityShlime(World world) {
        super(world);
        this.func_70105_a(0.675f, 0.75f);
        this.field_70767_i = new ShlimeJumpHelper(this);
        this.field_70765_h = new ShlimeMoveHelper(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(this, 1.33));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptMP((EntityCreature)this, 1.0, false, new ItemStack(NibiruItems.INFECTED_WHEAT)));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptMP((EntityCreature)this, 1.0, false, new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, 6)));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR, 1, 0));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR, 1, 0));
        this.setMovementSpeed(0.0);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP((EntityLiving)this, world);
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() == MPPotions.INFECTED_SPORE ? false : super.func_70687_e(potion);
    }

    public boolean canBreath() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() != NibiruBlocks.INFECTED_GRASS) return false;
        if (this.field_70170_p.func_175699_k(blockpos) <= 8) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        return true;
    }

    protected float func_175134_bD() {
        return this.field_70765_h.func_75640_a() && this.field_70765_h.func_179919_e() > this.field_70163_u + 0.5 ? 0.5f : this.moveType.getJumpHeight();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        if (this.sheepTimer > 0 && this.sheepTimer <= 40) {
            Block blockDown = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
            IBlockState block = this.field_70170_p.func_180495_p(this.func_180425_c());
            if (blockDown == NibiruBlocks.INFECTED_GRASS) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)NibiruBlocks.INFECTED_GRASS.func_176223_P())});
            } else if (blockDown == NibiruBlocks.GREEN_VEIN_GRASS) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)NibiruBlocks.GREEN_VEIN_GRASS.func_176223_P())});
            } else if (block == NibiruBlocks.NIBIRU_TALL_GRASS.func_176223_P().func_177226_a(BlockNibiruTallGrass.VARIANT, (Comparable)((Object)BlockNibiruTallGrass.BlockType.INFECTED_TALL_GRASS))) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)NibiruBlocks.NIBIRU_TALL_GRASS.func_176223_P().func_177226_a(BlockNibiruTallGrass.VARIANT, (Comparable)((Object)BlockNibiruTallGrass.BlockType.INFECTED_TALL_GRASS)))});
            } else if (block == NibiruBlocks.NIBIRU_TALL_GRASS.func_176223_P().func_177226_a(BlockNibiruTallGrass.VARIANT, (Comparable)((Object)BlockNibiruTallGrass.BlockType.GREEN_VEIN_TALL_GRASS))) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)NibiruBlocks.NIBIRU_TALL_GRASS.func_176223_P().func_177226_a(BlockNibiruTallGrass.VARIANT, (Comparable)((Object)BlockNibiruTallGrass.BlockType.GREEN_VEIN_TALL_GRASS)))});
            }
        }
        this.alterSquishAmount();
    }

    public void func_70619_bc() {
        if (this.field_70765_h.func_75638_b() > 0.8) {
            this.setMoveType(EnumMoveType.SPRINT);
        } else {
            this.setMoveType(EnumMoveType.HOP);
        }
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
        if (this.field_70122_E) {
            ShlimeJumpHelper jump;
            if (!this.wasOnGround) {
                this.setJumping(false, EnumMoveType.NONE);
                this.checkLandingDelay();
            }
            if (!(jump = (ShlimeJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path pathentity = this.field_70699_by.func_75505_d();
                    Vec3d vec3 = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (pathentity != null && pathentity.func_75873_e() < pathentity.func_75874_d()) {
                        vec3 = pathentity.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3.field_72450_a, vec3.field_72449_c);
                    this.doMovementAction(this.moveType);
                }
            } else if (!jump.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        if (this.jumpTicks != this.jumpDuration) {
            if (this.jumpTicks == 0 && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)1);
            }
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MPSounds.SHLIME_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MPSounds.SHLIME_DEATH;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return MPLootTables.SHLIME;
        }
        switch (this.getFleeceColor()) {
            default: {
                return MPLootTables.SHLIME_WOOL_WHITE;
            }
            case ORANGE: {
                return MPLootTables.SHLIME_WOOL_ORANGE;
            }
            case MAGENTA: {
                return MPLootTables.SHLIME_WOOL_MAGENTA;
            }
            case LIGHT_BLUE: {
                return MPLootTables.SHLIME_WOOL_LIGHT_BLUE;
            }
            case YELLOW: {
                return MPLootTables.SHLIME_WOOL_YELLOW;
            }
            case LIME: {
                return MPLootTables.SHLIME_WOOL_LIME;
            }
            case PINK: {
                return MPLootTables.SHLIME_WOOL_PINK;
            }
            case GRAY: {
                return MPLootTables.SHLIME_WOOL_GRAY;
            }
            case SILVER: {
                return MPLootTables.SHLIME_WOOL_SILVER;
            }
            case CYAN: {
                return MPLootTables.SHLIME_WOOL_CYAN;
            }
            case PURPLE: {
                return MPLootTables.SHLIME_WOOL_PURPLE;
            }
            case BLUE: {
                return MPLootTables.SHLIME_WOOL_BLUE;
            }
            case BROWN: {
                return MPLootTables.SHLIME_WOOL_BROWN;
            }
            case GREEN: {
                return MPLootTables.SHLIME_WOOL_GREEN;
            }
            case RED: {
                return MPLootTables.SHLIME_WOOL_RED;
            }
            case BLACK: 
        }
        return MPLootTables.SHLIME_WOOL_BLACK;
    }

    public EntityShlime createChild(EntityAgeable ageable) {
        EntityShlime entitysheep = (EntityShlime)ageable;
        EntityShlime entitysheep1 = new EntityShlime(this.field_70170_p);
        entitysheep1.setFleeceColor(this.getDyeColorMixFromParents(this, entitysheep));
        return entitysheep1;
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setFleeceColor(this.getRandomSheepColor(this.field_70170_p.field_73012_v));
        return super.func_180482_a(difficulty, data);
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return !itemStack.func_190926_b() && (itemStack.func_77973_b() == NibiruItems.INFECTED_WHEAT || itemStack.func_77973_b() == NibiruItems.NIBIRU_FRUITS && itemStack.func_77952_i() == 6);
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Sheared", this.getSheared());
        tagCompound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setSheared(tagCompund.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)tagCompund.func_74771_c("Color")));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.jumpDuration = 5;
            this.jumpTicks = 0;
        } else if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotationAngleX(float partialTicks) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - partialTicks) / 16.0f;
            return -0.62831855f + 0.439823f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : -76.39437f;
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    private void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    private int getMoveTypeDuration() {
        return this.moveType.getDuration();
    }

    private void setMoveType(EnumMoveType type) {
        this.moveType = type;
    }

    private void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    private void setJumping(boolean jump, EnumMoveType moveType) {
        super.func_70637_d(jump);
        if (!jump) {
            this.moveType = EnumMoveType.STEP;
        } else {
            this.setMovementSpeed(1.5 * (double)moveType.getSpeed());
        }
        this.wasJumping = jump;
    }

    private void doMovementAction(EnumMoveType movetype) {
        this.setJumping(true, movetype);
        this.jumpDuration = movetype.getJumpDuration();
        this.jumpTicks = 0;
    }

    private boolean isWasJumping() {
        return this.wasJumping;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 180.0 / Math.PI) - 90.0f;
    }

    private void enableJumpControl() {
        ((ShlimeJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((ShlimeJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.getMoveTypeDuration();
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    private EnumDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? EnumDyeColor.BLACK : (i < 10 ? EnumDyeColor.GRAY : (i < 15 ? EnumDyeColor.SILVER : (i < 18 ? EnumDyeColor.BROWN : (random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE))));
    }

    private EnumDyeColor getDyeColorMixFromParents(EntityAnimal father, EntityAnimal mother) {
        int i = ((EntityShlime)father).getFleeceColor().func_176767_b();
        int j = ((EntityShlime)mother).getFleeceColor().func_176767_b();
        this.inventoryCrafting.func_70301_a(0).func_77964_b(i);
        this.inventoryCrafting.func_70301_a(1).func_77964_b(j);
        ItemStack itemStack = CraftingManager.func_82787_a((InventoryCrafting)this.inventoryCrafting, (World)((EntityShlime)father).field_70170_p);
        int k = !itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR ? itemStack.func_77960_j() : (this.field_70170_p.field_73012_v.nextBoolean() ? i : j);
        return EnumDyeColor.func_176766_a((int)k);
    }

    private void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    static class AIPanic
    extends EntityAIPanic {
        private EntityShlime theEntity;

        public AIPanic(EntityShlime theEntity, double speed) {
            super((EntityCreature)theEntity, speed);
            this.theEntity = theEntity;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.theEntity.setMovementSpeed(this.field_75265_b);
        }
    }

    static class ShlimeMoveHelper
    extends EntityMoveHelper {
        private EntityShlime sheep;

        public ShlimeMoveHelper(EntityShlime sheep) {
            super((EntityLiving)sheep);
            this.sheep = sheep;
        }

        public void func_75641_c() {
            if (this.sheep.field_70122_E && !this.sheep.isWasJumping()) {
                this.sheep.setMovementSpeed(0.0);
            }
            super.func_75641_c();
        }
    }

    public class ShlimeJumpHelper
    extends EntityJumpHelper {
        private EntityShlime theEntity;
        private boolean canJump;

        public ShlimeJumpHelper(EntityShlime theEntity) {
            super((EntityLiving)theEntity);
            this.canJump = false;
            this.theEntity = theEntity;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.theEntity.doMovementAction(EnumMoveType.STEP);
                this.field_75662_b = false;
            }
        }
    }

    static enum EnumMoveType {
        NONE(0.0f, 0.0f, 10, 1),
        HOP(0.8f, 0.375f, 9, 6),
        STEP(1.0f, 0.45f, 7, 8),
        SPRINT(1.75f, 0.4f, 1, 4);

        private float speed;
        private float jumpHeight;
        private int duration;
        private int jumpDuration;

        private EnumMoveType(float typeSpeed, float jumpHeight, int typeDuration, int jumpDuration) {
            this.speed = typeSpeed;
            this.jumpHeight = jumpHeight;
            this.duration = typeDuration;
            this.jumpDuration = jumpDuration;
        }

        public float getSpeed() {
            return this.speed;
        }

        public float getJumpHeight() {
            return this.jumpHeight;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getJumpDuration() {
            return this.jumpDuration;
        }
    }
}

