/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.tileentity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNuclearWasteTank;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;

public class TileEntityNuclearWasteGenerator
extends TileBaseUniversalElectricalSource
implements IConnector,
IDisableableMachine {
    public int maxGenerate = 10000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float generateTick;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean missingTank;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean missingWaste;
    private int alertTick;
    public static final Map<BlockPos, IBlockState> multiBlockLists = new HashMap<BlockPos, IBlockState>();

    public TileEntityNuclearWasteGenerator() {
        super("container.nuclear_waste_generator.name");
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.setTierGC(4);
        this.storage.setCapacity(1.0E8f);
        this.storage.setMaxExtract((float)this.maxGenerate);
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.alertTick;
        if (!this.field_145850_b.field_72995_K) {
            if (!this.disabled) {
                if (this.generateTick > 0.0f) {
                    int z;
                    int x;
                    this.receiveEnergyGC(null, this.generateTick, false);
                    for (x = -1; x < 2; ++x) {
                        for (z = -1; z < 2; ++z) {
                            if (!this.getWaste(this.func_174877_v().func_177982_a(x, -1, z)) || this.field_145850_b.field_73012_v.nextInt(5000000) != 0) continue;
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(x, -1, z), Blocks.field_150343_Z.func_176223_P());
                        }
                    }
                    for (x = -3; x < 4; ++x) {
                        for (z = -3; z < 4; ++z) {
                            if (!this.getTank(this.func_174877_v().func_177982_a(x, 0, z))) continue;
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(x, 0, z), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)(this.field_145850_b.field_73012_v.nextInt(5000000) == 0 ? BlockNuclearWasteTank.BlockType.DEPLETE : BlockNuclearWasteTank.BlockType.NONE))));
                        }
                    }
                    this.ticks += this.field_145850_b.field_73012_v.nextInt(2);
                    if (this.ticks % 33 == 0) {
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), MPSounds.MACHINE_GENERATOR_AMBIENT, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    if (this.alertTick % 100 == 0 && (this.missingWaste || this.missingTank)) {
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), MPSounds.MACHINE_ALERT, SoundCategory.BLOCKS, 5.0f, 1.0f);
                    }
                }
                this.missingWaste = !this.getWaste(this.func_174877_v().func_177982_a(1, -1, 0)) || !this.getWaste(this.func_174877_v().func_177982_a(-1, -1, 0)) || !this.getWaste(this.func_174877_v().func_177982_a(0, -1, 1)) || !this.getWaste(this.func_174877_v().func_177982_a(0, -1, -1)) || !this.getWaste(this.func_174877_v().func_177982_a(1, -1, 1)) || !this.getWaste(this.func_174877_v().func_177982_a(-1, -1, 1)) || !this.getWaste(this.func_174877_v().func_177982_a(-1, -1, -1)) || !this.getWaste(this.func_174877_v().func_177982_a(1, -1, -1));
                this.missingTank = !this.getTank(this.func_174877_v().func_177982_a(3, 0, 0)) || !this.getTank(this.func_174877_v().func_177982_a(-3, 0, 0)) || !this.getTank(this.func_174877_v().func_177982_a(0, 0, 3)) || !this.getTank(this.func_174877_v().func_177982_a(0, 0, -3)) || !this.getTank(this.func_174877_v().func_177982_a(2, 0, 2)) || !this.getTank(this.func_174877_v().func_177982_a(-2, 0, 2)) || !this.getTank(this.func_174877_v().func_177982_a(2, 0, -2)) || !this.getTank(this.func_174877_v().func_177982_a(-2, 0, -2));
                this.generateTick = this.getWaste(this.func_174877_v().func_177982_a(1, -1, 0)) && this.getWaste(this.func_174877_v().func_177982_a(-1, -1, 0)) && this.getWaste(this.func_174877_v().func_177982_a(0, -1, 1)) && this.getWaste(this.func_174877_v().func_177982_a(0, -1, -1)) && this.getWaste(this.func_174877_v().func_177982_a(1, -1, 1)) && this.getWaste(this.func_174877_v().func_177982_a(-1, -1, 1)) && this.getWaste(this.func_174877_v().func_177982_a(-1, -1, -1)) && this.getWaste(this.func_174877_v().func_177982_a(1, -1, -1)) && this.getTank(this.func_174877_v().func_177982_a(3, 0, 0)) && this.getTank(this.func_174877_v().func_177982_a(-3, 0, 0)) && this.getTank(this.func_174877_v().func_177982_a(0, 0, 3)) && this.getTank(this.func_174877_v().func_177982_a(0, 0, -3)) && this.getTank(this.func_174877_v().func_177982_a(2, 0, 2)) && this.getTank(this.func_174877_v().func_177982_a(-2, 0, 2)) && this.getTank(this.func_174877_v().func_177982_a(2, 0, -2)) && this.getTank(this.func_174877_v().func_177982_a(-2, 0, -2)) ? Math.min(this.generateTick + Math.max(this.generateTick * 0.005f, 1.0f), (float)this.maxGenerate) : Math.max(this.generateTick - 10.0f, 0.0f);
                this.generateTick = Math.min(Math.max(this.generateTick, 0.0f), this.getMaxEnergyStoredGC());
            }
            this.produce();
            this.recharge((ItemStack)this.getInventory().get(0));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.generateTick = nbt.func_74760_g("GenerateTick");
        this.setDisabled(0, nbt.func_74767_n("Disabled"));
        this.disableCooldown = nbt.func_74762_e("DisabledCooldown");
        this.missingTank = nbt.func_74767_n("MissingTank");
        this.missingWaste = nbt.func_74767_n("MissingWaste");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("GenerateTick", this.generateTick);
        nbt.func_74768_a("DisabledCooldown", this.disableCooldown);
        nbt.func_74757_a("Disabled", this.getDisabled(0));
        nbt.func_74757_a("MissingTank", this.missingTank);
        nbt.func_74757_a("MissingWaste", this.missingWaste);
        return nbt;
    }

    private boolean getWaste(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos) == NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P();
    }

    private boolean getTank(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos) == NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)(this.field_145850_b.field_73012_v.nextFloat() == 0.99f ? BlockNuclearWasteTank.BlockType.DEPLETE : BlockNuclearWasteTank.BlockType.NONE)));
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public EnumFacing getElectricOutputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.nuclear_waste_generator.name");
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return slot == 0;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public String getStatus() {
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.missingTank && this.missingWaste) {
            return TextFormatting.RED + GCCoreUtil.translate((String)"gui.status.waste_and_tank_depleted.name");
        }
        if (this.missingTank) {
            return TextFormatting.RED + GCCoreUtil.translate((String)"gui.status.waste_tank_depleted.name");
        }
        if (this.missingWaste) {
            return TextFormatting.RED + GCCoreUtil.translate((String)"gui.status.waste_depleted.name");
        }
        if (this.generateTick > 0.0f) {
            return TextFormatting.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        return TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.status.no_waste_sources.name");
    }

    static {
        multiBlockLists.put(new BlockPos(1, -1, 0), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(1, -1, 1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(1, -1, -1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -1, -1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -1, 1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -1, 0), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -1, 1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -1, -1), NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 0, 0), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(2, 0, 2), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(2, 0, -2), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 0, 0), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(-2, 0, -2), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(-2, 0, 2), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, 0, 3), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, 0, -3), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P());
    }
}

