/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.StructureNibiruVillagePieces;
import stevekung.mods.moreplanets.util.MPLog;

public class MapGenNibiruVillage
extends MapGenStructure {
    public static List<Biome> VILLAGE_SPAWN_BIOMES = new ArrayList<Biome>(Arrays.asList(MPBiomes.INFECTED_PLAINS, MPBiomes.INFECTED_DESERT, MPBiomes.INFECTED_DEAD_SAVANNA, MPBiomes.GREEN_VEIN));
    private int size;
    private int distance = 32;

    public String func_143025_a() {
        return "NibiruVillage";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        return i == (k += random.nextInt(this.distance - 8)) && j == (l += random.nextInt(this.distance - 8)) && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, VILLAGE_SPAWN_BIOMES));
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenStructure.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"NibiruVillage");
        StructureNibiruVillagePieces.registerVillagePieces();
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World world, Random rand, int x, int z, int size) {
            super(x, z);
            MPLog.debug("Generate village at x:{} z:{}", x * 16, z * 16);
            List<StructureNibiruVillagePieces.PieceWeight> list = StructureNibiruVillagePieces.getStructureVillageWeightedPieceList(rand, size);
            StructureNibiruVillagePieces.Start start = new StructureNibiruVillagePieces.Start(world.func_72959_q(), rand, (x << 4) + 2, (z << 4) + 2, list, size);
            this.field_75075_a.add(start);
            start.func_74861_a(start, this.field_75075_a, rand);
            List<StructureComponent> list1 = start.pendingRoads;
            List<StructureComponent> list2 = start.pendingHouses;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = rand.nextInt(list2.size());
                    StructureComponent structurecomponent = list2.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)start, this.field_75075_a, rand);
                    continue;
                }
                int j = rand.nextInt(list1.size());
                StructureComponent structurecomponent2 = list1.remove(j);
                structurecomponent2.func_74861_a((StructureComponent)start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureNibiruVillagePieces.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

