/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.blocks.BlockDummy;
import stevekung.mods.moreplanets.blocks.BlockShieldGenerator;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.moreplanets.util.EnumParticleTypesMP;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public class TileEntityShieldGenerator
extends TileEntityDummy
implements IMultiBlock,
IBubbleProvider {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int facing;
    public int renderTicks;
    public int solarRotate;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float shieldSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float prevShieldSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRender = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean enableShield = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean enableDamage = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldSize = 16;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldSizeUpgrade;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldCapacity;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldCapacity = 16000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldDamage = 8;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldDamage;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldChargeCooldown = 1200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean needCharged;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerUUID = "";
    private boolean initialize = true;
    private final ShieldEvent event = new ShieldEvent(this);

    public TileEntityShieldGenerator() {
        super("container.shield_generator.name");
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.storage.setMaxExtract(250.0f);
        this.storage.setCapacity(100000.0f);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.event);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.event);
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this.event);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (this.initialize) {
            this.renderTicks += this.field_145850_b.field_73012_v.nextInt(100);
            this.solarRotate += this.field_145850_b.field_73012_v.nextInt(360);
            this.initialize = false;
        }
        if (this.hasEnoughEnergyToRun && !this.disabled) {
            ++this.solarRotate;
            this.solarRotate %= 360;
            MorePlanetsCore.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_MINER_SPARK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, new Object[]{Float.valueOf(-0.5f)});
            if (this.ticks % 33 == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), MPSounds.MACHINE_GENERATOR_AMBIENT, SoundCategory.BLOCKS, 0.075f, 1.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int count = 0;
            int capacityUpgradeCount = 0;
            if (!((ItemStack)this.getInventory().get(1)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(1)).func_190916_E();
                this.maxShieldDamage = 8 * count;
            } else {
                this.maxShieldDamage = 8;
            }
            if (!((ItemStack)this.getInventory().get(2)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(2)).func_190916_E();
                this.maxShieldSizeUpgrade = 16 + count;
            } else {
                this.maxShieldSizeUpgrade = 16;
            }
            if (!((ItemStack)this.getInventory().get(3)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(3)).func_190916_E();
                capacityUpgradeCount = ((ItemStack)this.getInventory().get(3)).func_190916_E();
                this.maxShieldCapacity = 32000 * count;
            } else {
                this.maxShieldCapacity = 16000;
            }
            int sum = (int)((float)this.shieldDamage + this.shieldSize + (float)capacityUpgradeCount) / 2;
            this.storage.setMaxExtract((float)(250 * sum));
            if (!this.needCharged && this.shieldCapacity == 0) {
                this.needCharged = true;
                this.shieldChargeCooldown = 1200;
                if (this.shieldChargeCooldown == 0) {
                    this.shieldCapacity = 100;
                }
            }
            if (!this.disabled && this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun) {
                if (this.shieldSize <= (float)this.maxShieldSize) {
                    this.shieldSize += 0.1f;
                    if (this.shieldChargeCooldown > 0) {
                        --this.shieldChargeCooldown;
                    }
                    if (this.shieldChargeCooldown == 0 && this.ticks % 2 == 0) {
                        this.shieldCapacity += 100;
                        this.needCharged = false;
                    }
                }
            } else {
                this.shieldSize -= 0.1f;
            }
            this.shieldSize = this.shieldSize <= (float)this.maxShieldSize ? Math.min(Math.max(this.shieldSize, 0.0f), (float)this.maxShieldSize) : (this.shieldSize -= 0.1f);
            this.shieldCapacity = Math.min(Math.max(this.shieldCapacity, 0), this.maxShieldCapacity);
        }
        float range = this.shieldSize;
        List entitiesMob = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range), (double)((float)this.field_174879_c.func_177956_o() + range), (double)((float)this.field_174879_c.func_177952_p() + range)));
        for (Entity entity : entitiesMob) {
            if (this.disabled || !this.enableShield || this.shieldCapacity <= 0 || !(entity instanceof EntityArrow && !(((EntityArrow)entity).field_70250_c instanceof EntityPlayer) && !((EntityArrow)entity).field_70254_i || entity instanceof EntityPotion && !(((EntityPotion)entity).func_85052_h() instanceof EntityPlayer) || entity instanceof EntityFireball) && !(entity instanceof EntityShulkerBullet)) continue;
            if (this.field_145850_b instanceof WorldServer) {
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
            }
            float motion = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            this.shieldCapacity = (int)((float)this.shieldCapacity - motion * 2.0f);
            entity.func_70106_y();
        }
    }

    public boolean onActivated(EntityPlayer player) {
        return ((BlockShieldGenerator)MPBlocks.SHIELD_GENERATOR).onMachineActivated(this.field_145850_b, this.mainBlockPosition, MPBlocks.SHIELD_GENERATOR.func_176223_P(), player, player.func_184600_cs(), player.func_184614_ca(), player.func_174811_aO(), 0.0f, 0.0f, 0.0f);
    }

    public void onCreate(World world, BlockPos pos) {
        this.mainBlockPosition = pos;
    }

    public void onDestroy(TileEntity tile) {
        BlockPos thisBlock = this.func_174877_v();
        if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
            FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(thisBlock.func_177984_a(), MPBlocks.DUMMY_BLOCK.func_176223_P().func_177226_a(BlockDummy.VARIANT, (Comparable)((Object)BlockDummy.BlockType.SHIELD_GENERATOR_TOP)));
        }
        this.destroyBlock();
        this.field_145850_b.func_175655_b(thisBlock.func_177984_a(), false);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public double getPacketRange() {
        return 64.0;
    }

    public int getPacketCooldown() {
        return 1;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setBubbleVisible(nbt.func_74767_n("ShieldVisible"));
        this.shieldSize = nbt.func_74760_g("ShieldSize");
        this.maxShieldSize = nbt.func_74762_e("MaxShieldSize");
        this.shieldDamage = nbt.func_74762_e("ShieldDamage");
        this.maxShieldDamage = nbt.func_74762_e("MaxShieldDamage");
        this.shieldCapacity = nbt.func_74762_e("ShieldCapacity");
        this.maxShieldCapacity = nbt.func_74762_e("MaxShieldCapacity");
        this.shieldChargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
        this.needCharged = nbt.func_74767_n("NeedCharged");
        this.enableShield = nbt.func_74767_n("EnableShield");
        this.enableDamage = nbt.func_74767_n("EnableDamage");
        this.facing = nbt.func_74762_e("Facing");
        this.ownerUUID = nbt.func_74779_i("OwnerUUID");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("ShieldVisible", this.shouldRender);
        nbt.func_74776_a("ShieldSize", this.shieldSize);
        nbt.func_74768_a("MaxShieldSize", this.maxShieldSize);
        nbt.func_74768_a("ShieldDamage", this.shieldDamage);
        nbt.func_74768_a("MaxShieldDamage", this.maxShieldDamage);
        nbt.func_74768_a("ShieldCapacity", this.shieldCapacity);
        nbt.func_74768_a("MaxShieldCapacity", this.maxShieldCapacity);
        nbt.func_74768_a("ShieldChargeCooldown", this.shieldChargeCooldown);
        nbt.func_74757_a("NeedCharged", this.needCharged);
        nbt.func_74757_a("EnableShield", this.enableShield);
        nbt.func_74757_a("EnableDamage", this.enableDamage);
        nbt.func_74768_a("Facing", this.facing);
        if (this.ownerUUID != null) {
            nbt.func_74778_a("OwnerUUID", this.ownerUUID);
        }
        return nbt;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return itemStack.func_77973_b() == Items.field_151137_ax;
        }
        if (slot == 2) {
            return itemStack.func_77973_b() == Items.field_151079_bi;
        }
        if (slot == 3) {
            return itemStack.func_77973_b() == Items.field_151045_i;
        }
        return slot == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.disabled;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockShieldGenerator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void setBubbleVisible(boolean render) {
        this.shouldRender = render;
    }

    public float getBubbleSize() {
        return this.shieldSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRender;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public String getStatus() {
        if (this.getEnergyStoredGC() == 0.0f) {
            return TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + GCCoreUtil.translate((String)"gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return TextFormatting.GOLD + GCCoreUtil.translate((String)"gui.status.missingpower.name");
        }
        if (this.needCharged) {
            return TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.status.shield_charging.name");
        }
        return TextFormatting.GREEN + GCCoreUtil.translate((String)"gui.status.active.name");
    }

    private boolean isInRangeOfShield(BlockPos pos) {
        double dx = this.field_174879_c.func_177958_n() - pos.func_177958_n();
        double dy = Math.abs(this.field_174879_c.func_177956_o() - pos.func_177956_o());
        double dz = this.field_174879_c.func_177952_p() - pos.func_177952_p();
        return dx * dx + dz * dz <= (double)(this.shieldSize * this.shieldSize) && dy <= (double)this.shieldSize;
    }

    private boolean destroyBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        this.field_145850_b.func_175718_b(2001, this.field_174879_c, Block.func_176210_f((IBlockState)state));
        ItemStack machine = new ItemStack(MPBlocks.SHIELD_GENERATOR);
        TileEntityShieldGenerator shield = this;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("ShieldSize", shield.shieldSize);
        nbt.func_74768_a("MaxShieldSize", shield.maxShieldSize);
        nbt.func_74768_a("ShieldDamage", shield.shieldDamage);
        nbt.func_74768_a("MaxShieldDamage", shield.maxShieldDamage);
        nbt.func_74768_a("ShieldCapacity", shield.shieldCapacity);
        nbt.func_74768_a("MaxShieldCapacity", shield.maxShieldCapacity);
        nbt.func_74768_a("ShieldChargeCooldown", shield.shieldChargeCooldown);
        nbt.func_74757_a("NeedCharged", shield.needCharged);
        nbt.func_74757_a("EnableShield", shield.enableShield);
        nbt.func_74757_a("EnableDamage", shield.enableDamage);
        if (shield.getEnergyStoredGC() > 0.0f) {
            nbt.func_74776_a("EnergyStored", shield.getEnergyStoredGC());
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)shield.inventory);
        machine.func_77982_d(nbt);
        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)machine);
        return this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public static class ShieldEvent {
        private TileEntityShieldGenerator tile;

        public ShieldEvent(TileEntityShieldGenerator tile) {
            this.tile = tile;
        }

        @SubscribeEvent
        public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
            if (event.getResult() == Event.Result.ALLOW || event.isSpawner()) {
                return;
            }
            if (this.tile.field_145850_b != null && !((TileEntityShieldGenerator)this.tile).field_145850_b.field_72995_K && !this.tile.disabled && this.tile.isInRangeOfShield(event.getEntity().func_180425_c())) {
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent
        public void onEnderTeleport(EnderTeleportEvent event) {
            if (!this.tile.disabled && this.tile.isInRangeOfShield(event.getEntity().func_180425_c())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof IMob && !this.tile.disabled && this.tile.enableShield && this.tile.shieldCapacity > 0 && this.tile.isInRangeOfShield(event.getEntity().func_180425_c())) {
                UUID uuid;
                if (!this.tile.enableDamage) {
                    double d13;
                    double d4 = entity.func_70011_f((double)this.tile.field_174879_c.func_177958_n(), (double)this.tile.field_174879_c.func_177956_o(), (double)this.tile.field_174879_c.func_177952_p());
                    double d6 = entity.field_70165_t - (double)this.tile.field_174879_c.func_177958_n();
                    double d8 = entity.field_70163_u - (double)this.tile.field_174879_c.func_177956_o();
                    double d10 = entity.field_70161_v - (double)this.tile.field_174879_c.func_177952_p();
                    double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
                    double d14 = d13 = (0.0 - d4) * 2.0 / 10.0;
                    double knockSpeed = 10.0;
                    entity.field_70159_w -= (d6 /= d11) * d14 / knockSpeed;
                    entity.field_70181_x -= (d8 /= d11) * d14 / knockSpeed;
                    entity.field_70179_y -= (d10 /= d11) * d14 / knockSpeed;
                }
                try {
                    uuid = UUID.fromString(this.tile.ownerUUID);
                }
                catch (Exception e) {
                    uuid = UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4");
                }
                if (uuid != null && this.tile.field_145850_b.func_152378_a(uuid) != null) {
                    if (entity.field_70173_aa % 8 == 0 && this.tile.field_145850_b instanceof WorldServer) {
                        ((WorldServer)this.tile.field_145850_b).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                    }
                    if (this.tile.enableDamage) {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.tile.field_145850_b.func_152378_a(uuid)), (float)this.tile.shieldDamage);
                    }
                } else {
                    if (entity.field_70173_aa % 8 == 0 && this.tile.field_145850_b instanceof WorldServer) {
                        ((WorldServer)this.tile.field_145850_b).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                    }
                    if (this.tile.enableDamage) {
                        entity.func_70097_a(DamageSource.field_76377_j, (float)this.tile.shieldDamage);
                    }
                }
                float motion = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
                this.tile.shieldCapacity = (int)((float)this.tile.shieldCapacity - motion * 2.0f);
            }
        }
    }
}

