/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.util.CachedEnumUtil;
import stevekung.mods.moreplanets.util.helper.CommonRegisterHelper;
import stevekung.mods.moreplanets.util.items.EnumSortCategoryItem;
import stevekung.mods.moreplanets.util.items.ISortableItem;
import stevekung.mods.moreplanets.util.items.ItemBaseMP;

public abstract class ItemRocketBaseMP
extends ItemBaseMP
implements IHoldableItem,
ISortableItem {
    public ItemRocketBaseMP() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean padFound = false;
        TileEntity tile = null;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = world.func_180495_p(pos1);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (block != GCBlocks.landingPadFull || meta != 0) continue;
                padFound = true;
                tile = world.func_175625_s(pos1);
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (!padFound) return EnumActionResult.PASS;
        if (!(tile instanceof TileEntityLandingPad)) return EnumActionResult.PASS;
        if (((TileEntityLandingPad)tile).getDockedEntity() != null) {
            return EnumActionResult.PASS;
        }
        this.spawnRocket(itemStack, world, player, centerX, centerY, centerZ);
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (CommonRegisterHelper.isItemTab(creativeTabs)) {
            for (int i = 0; i < CachedEnumUtil.valuesRocketCached().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        IRocketType.EnumRocketType type = itemStack.func_77952_i() < 10 ? CachedEnumUtil.valuesRocketCached()[itemStack.func_77952_i()] : CachedEnumUtil.valuesRocketCached()[itemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            list.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            list.add(TextFormatting.RED + "" + TextFormatting.ITALIC + GCCoreUtil.translate((String)"gui.creative_only.desc"));
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("RocketFuel")) {
            this.addDescription(itemStack, list);
        }
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    @Override
    public EnumSortCategoryItem getItemCategory(int meta) {
        return EnumSortCategoryItem.ROCKET;
    }

    protected abstract void spawnRocket(ItemStack var1, World var2, EntityPlayer var3, float var4, float var5, float var6);

    @SideOnly(value=Side.CLIENT)
    protected abstract void addDescription(ItemStack var1, List<String> var2);
}

