/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockModPortal
extends BlockMod {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);

    public BlockModPortal(ResourceLocation registryName, BlockProperties properties) {
        super(registryName, properties);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double posX = (float)pos.func_177958_n() + random.nextFloat();
            double posY = (float)pos.func_177956_o() + random.nextFloat();
            double posZ = (float)pos.func_177952_p() + random.nextFloat();
            double speedX = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedY = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedZ = ((double)random.nextFloat() - 0.5) * 0.5;
            int multiplier = random.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                posX = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)multiplier;
                speedX = random.nextFloat() * 2.0f * (float)multiplier;
            } else {
                posZ = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)multiplier;
                speedZ = random.nextFloat() * 2.0f * (float)multiplier;
            }
            world.func_175688_a(EnumParticleTypes.PORTAL, posX, posY, posZ, speedX, speedY, speedZ, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            if (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d())) {
                world.func_175698_g(pos);
            }
        } else if (axis == EnumFacing.Axis.Y) {
            if (world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f())) {
                world.func_175698_g(pos);
            }
        } else if (axis == EnumFacing.Axis.Z && (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f()))) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, 2);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            if ((pos.func_177976_e().equals((Object)fromPos) || pos.func_177974_f().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
                world.func_175698_g(fromPos);
            }
        } else if (axis == EnumFacing.Axis.Y) {
            if ((pos.func_177977_b().equals((Object)fromPos) || pos.func_177984_a().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
                world.func_175698_g(fromPos);
            }
        } else if (axis == EnumFacing.Axis.Z && (pos.func_177978_c().equals((Object)fromPos) || pos.func_177968_d().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
            world.func_175698_g(fromPos);
        }
        world.func_175684_a(pos, (Block)this, 1);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public abstract void func_180634_a(World var1, BlockPos var2, IBlockState var3, Entity var4);

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Y: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return BlockModPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta]);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 0 : (axis == EnumFacing.Axis.Y ? 1 : 2);
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            for (EnumFacing facing : EnumFacing.values()) {
                Queue<BlockPos> portalBlocks = this.findPortalBlocks(world, pos.func_177972_a(facing), axis);
                if (portalBlocks.size() <= 0) continue;
                for (BlockPos newPos : portalBlocks) {
                    world.func_175656_a(newPos, this.func_176223_P().func_177226_a(AXIS, (Comparable)axis));
                }
                return true;
            }
        }
        return false;
    }

    private Queue<BlockPos> findPortalBlocks(World world, BlockPos pos, EnumFacing.Axis axis) {
        ArrayDeque<BlockPos> portalBlocks = new ArrayDeque<BlockPos>();
        ArrayDeque<BlockPos> toProcess = new ArrayDeque<BlockPos>();
        int chances = 0;
        toProcess.add(pos);
        while (!toProcess.isEmpty()) {
            BlockPos newPos = (BlockPos)toProcess.remove();
            if (portalBlocks.contains(newPos)) continue;
            if (world.func_175623_d(newPos) || this.isPortalIgniter(world, newPos)) {
                int neighborBlocks = this.getNeighborBlocks(world, newPos, portalBlocks, axis);
                if (neighborBlocks < 2) {
                    if (chances < 40) {
                        ++chances;
                        neighborBlocks += 2;
                    } else {
                        return new ArrayDeque<BlockPos>();
                    }
                }
                if (neighborBlocks >= 2) {
                    portalBlocks.add(newPos);
                    this.addNeighborBlocks(newPos, axis, toProcess);
                    continue;
                }
                if (this.isPortalPart(world, newPos)) continue;
                return new ArrayDeque<BlockPos>();
            }
            if (this.isPortalPart(world, newPos)) continue;
            return new ArrayDeque<BlockPos>();
        }
        return portalBlocks;
    }

    private int getNeighborBlocks(World world, BlockPos pos, Queue<BlockPos> portalBlocks, EnumFacing.Axis axis) {
        int sides = 0;
        ArrayDeque<BlockPos> neighbors = new ArrayDeque<BlockPos>();
        this.addNeighborBlocks(pos, axis, neighbors);
        for (BlockPos newPos : neighbors) {
            if (!portalBlocks.contains(newPos) && !this.isPortalPart(world, newPos)) continue;
            ++sides;
        }
        return sides;
    }

    private void addNeighborBlocks(BlockPos pos, EnumFacing.Axis axis, Queue<BlockPos> neighbors) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (axis == EnumFacing.Axis.X && (facing == EnumFacing.EAST || facing == EnumFacing.WEST) || axis == EnumFacing.Axis.Y && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || axis == EnumFacing.Axis.Z && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)) continue;
            neighbors.add(pos.func_177972_a(facing));
        }
    }

    public abstract boolean isPortalIgniter(World var1, BlockPos var2);

    public abstract boolean isPortalPart(World var1, BlockPos var2);
}

