/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.client.util;

import java.util.Map;
import logictechcorp.libraryex.api.IModData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelHelper {
    private static StateMapperBase stringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation(Blocks.field_150350_a.getRegistryName().toString());
        }
    };

    public static void registerBlockItemModel(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            ModelHelper.registerItemModel(item, new ModelResourceLocation(block.getRegistryName(), stringMapper.func_178131_a((Map)state.func_177228_b())));
        }
    }

    public static void registerBlockItemModel(IBlockState state, String variant) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            ModelHelper.registerItemModel(item, new ModelResourceLocation(block.getRegistryName(), variant));
        }
    }

    public static void registerItemModel(Item item) {
        ModelHelper.registerItemModel(item, item.getRegistryName().toString());
    }

    public static void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        ModelHelper.registerItemModel(item, fullModelLocation);
    }

    public static void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        ModelHelper.registerItemModel(item, stack -> fullModelLocation);
    }

    public static void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    public static void registerItemModelForMeta(Item item, int metadata, String variant) {
        ModelHelper.registerItemModelForMeta(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    public static void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation resourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)resourceLocation);
    }

    public static void registerFluidModel(IModData data, IFluidBlock block) {
        Item item = Item.func_150898_a((Block)((Block)block));
        if (item != Items.field_190931_a) {
            final ModelResourceLocation resourceLocation = new ModelResourceLocation(data.getModId() + ":" + block.getFluid().getName());
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, stack -> resourceLocation);
            ModelLoader.setCustomStateMapper((Block)((Block)block), (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return resourceLocation;
                }
            });
        }
    }
}

