/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome.data;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.json.JsonFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import logictechcorp.libraryex.api.LibraryExAPI;
import logictechcorp.libraryex.api.world.biome.BiomeBlockType;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.biome.data.IBiomeDataRegistry;
import logictechcorp.libraryex.api.world.generation.GenerationStage;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTrait;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTraitBuilder;
import logictechcorp.libraryex.utility.ConfigHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeData
implements IBiomeData {
    protected final Biome biome;
    protected int generationWeight;
    protected boolean useDefaultDecorations;
    protected boolean isSubBiome;
    protected boolean isEnabled;
    protected final Map<BiomeBlockType, IBlockState> biomeBlocks;
    protected final Map<GenerationStage, List<IBiomeTrait>> biomeTraits;
    protected final Map<EnumCreatureType, List<Biome.SpawnListEntry>> entitySpawns;
    protected final List<Biome.SpawnListEntry> disabledEntitySpawns;
    protected final List<IBiomeData> subBiomes;

    public BiomeData(Biome biome, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome, boolean isEnabled) {
        this.biome = biome != null ? biome : Biomes.field_76772_c;
        this.generationWeight = generationWeight;
        this.useDefaultDecorations = useDefaultDecorations;
        this.isEnabled = isEnabled;
        this.isSubBiome = isSubBiome;
        this.biomeBlocks = new EnumMap<BiomeBlockType, IBlockState>(BiomeBlockType.class);
        this.biomeTraits = new EnumMap<GenerationStage, List<IBiomeTrait>>(GenerationStage.class);
        this.entitySpawns = new EnumMap<EnumCreatureType, List<Biome.SpawnListEntry>>(EnumCreatureType.class);
        this.disabledEntitySpawns = new ArrayList<Biome.SpawnListEntry>();
        this.subBiomes = new ArrayList<IBiomeData>();
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            for (Biome.SpawnListEntry entry : this.biome.func_76747_a(creatureType)) {
                this.addEntitySpawn(creatureType, entry);
            }
        }
    }

    public BiomeData(ResourceLocation biomeRegistryName, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome, boolean isEnabled) {
        this((Biome)ForgeRegistries.BIOMES.getValue(biomeRegistryName), generationWeight, useDefaultDecorations, isSubBiome, isEnabled);
    }

    @Override
    public void addBiomeBlock(BiomeBlockType blockType, IBlockState state) {
        this.biomeBlocks.put(blockType, state);
    }

    @Override
    public void addEntitySpawn(EnumCreatureType creatureType, Biome.SpawnListEntry spawnListEntry) {
        if (spawnListEntry.field_76292_a <= 0) {
            this.disabledEntitySpawns.add(spawnListEntry);
        } else {
            this.entitySpawns.computeIfAbsent(creatureType, k -> new ArrayList()).add(spawnListEntry);
        }
    }

    @Override
    public void addBiomeTrait(GenerationStage generationStage, IBiomeTrait biomeTrait) {
        this.biomeTraits.computeIfAbsent(generationStage, k -> new ArrayList()).add(biomeTrait);
    }

    @Override
    public void addSubBiome(IBiomeData biomeData) {
        this.subBiomes.add(biomeData);
    }

    @Override
    public void readFromConfig(IBiomeDataRegistry biomeDataRegistry, Config config) {
        this.generationWeight = (Integer)config.getOrElse("generationWeight", (Object)this.generationWeight);
        if (this.generationWeight <= 0) {
            this.generationWeight = 10;
        }
        this.useDefaultDecorations = (Boolean)config.getOrElse("useDefaultDecorations", (Object)true);
        this.isSubBiome = (Boolean)config.getOrElse("isSubBiome", (Object)false);
        this.isEnabled = (Boolean)config.getOrElse("isEnabled", (Object)true);
        if (!(config.get("blocks") instanceof Config)) {
            config.set("blocks", (Object)JsonFormat.newConfig(LinkedHashMap::new));
        }
        Config blocks = (Config)config.get("blocks");
        this.biomeBlocks.clear();
        for (Object entry : blocks.entrySet()) {
            IBlockState state = ConfigHelper.getBlockState(config, "blocks." + entry.getKey());
            if (state == null) continue;
            this.biomeBlocks.put(BiomeBlockType.getFromIdentifier(entry.getKey()), state);
        }
        if (!(config.get("entities") instanceof List)) {
            config.set("entities", new ArrayList());
        }
        List entities = (List)config.get("entities");
        this.entitySpawns.clear();
        this.disabledEntitySpawns.clear();
        block1: for (Config entityConfig : entities) {
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation((String)entityConfig.get("entity")));
            if (entityEntry == null) continue;
            Class cls = entityEntry.getEntityClass();
            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                if (!EntityLiving.class.isAssignableFrom(cls) || !creatureType.func_75598_a().isAssignableFrom(cls)) continue;
                int spawnWeight = (Integer)entityConfig.getOrElse("spawnWeight", (Object)10);
                int minimumGroupCount = (Integer)entityConfig.getOrElse("minimumGroupCount", (Object)1);
                int maximumGroupCount = (Integer)entityConfig.getOrElse("maximumGroupCount", (Object)4);
                if (spawnWeight < 0) {
                    spawnWeight = 0;
                }
                this.addEntitySpawn(creatureType, new Biome.SpawnListEntry(cls, spawnWeight, minimumGroupCount, maximumGroupCount));
                continue block1;
            }
        }
        if (!(config.get("traits") instanceof List)) {
            config.set("traits", new ArrayList());
        }
        ArrayList<Config> biomeTraits = new ArrayList<Config>();
        List biomeTraitConfigs = (List)config.get("traits");
        this.biomeTraits.clear();
        for (Config biomeTraitConfig : biomeTraitConfigs) {
            IBiomeTraitBuilder biomeTraitBuilder = LibraryExAPI.getInstance().getBiomeTraitRegistry().getBiomeTraitBuilder(new ResourceLocation((String)biomeTraitConfig.get("trait")));
            if (biomeTraitBuilder != null) {
                Object biomeTrait = biomeTraitBuilder.create();
                biomeTrait.readFromConfig(biomeTraitConfig);
                this.addBiomeTrait(GenerationStage.getFromIdentifier((String)biomeTraitConfig.get("generationStage")), (IBiomeTrait)biomeTrait);
            }
            biomeTraits.add(biomeTraitConfig);
        }
        config.set("traits", biomeTraits);
        if (!this.isSubBiome) {
            if (!(config.get("subBiomes") instanceof List)) {
                config.set("subBiomes", new ArrayList());
            }
            List subBiomeNames = (List)config.get("subBiomes");
            this.subBiomes.clear();
            for (String subBiomeName : subBiomeNames) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(subBiomeName));
                if (biome == null || !biomeDataRegistry.hasBiomeData(biome)) continue;
                this.subBiomes.add(biomeDataRegistry.getBiomeData(biome));
            }
        }
    }

    @Override
    public void writeToConfig(Config config) {
        config.add("biome", (Object)this.biome.getRegistryName().toString());
        config.add("generationWeight", (Object)this.generationWeight);
        config.add("useDefaultDecorations", (Object)this.useDefaultDecorations);
        config.add("isSubBiome", (Object)this.isSubBiome);
        config.add("isEnabled", (Object)this.isEnabled);
        Config blockConfigs = JsonFormat.newConfig(LinkedHashMap::new);
        for (Map.Entry<BiomeBlockType, IBlockState> entry : this.biomeBlocks.entrySet()) {
            ConfigHelper.setBlockState(blockConfigs, entry.getKey().toString(), entry.getValue());
        }
        config.set("blocks", (Object)blockConfigs);
        ArrayList<Object> entityConfigs = new ArrayList<Object>();
        for (EnumCreatureType type : EnumCreatureType.values()) {
            if (!this.entitySpawns.containsKey(type)) {
                this.entitySpawns.put(type, new ArrayList(this.biome.func_76747_a(type)));
            }
            for (Biome.SpawnListEntry entry : this.entitySpawns.get(type)) {
                ResourceLocation entityRegistryName = EntityList.func_191306_a((Class)entry.field_76300_b);
                if (entityRegistryName == null) continue;
                Config entityConfig = JsonFormat.newConfig(LinkedHashMap::new);
                entityConfig.add("entity", (Object)entityRegistryName.toString());
                entityConfig.add("spawnWeight", (Object)entry.field_76292_a);
                entityConfig.add("minimumGroupCount", (Object)entry.field_76301_c);
                entityConfig.add("maximumGroupCount", (Object)entry.field_76299_d);
                entityConfigs.add(entityConfig);
            }
        }
        for (Biome.SpawnListEntry entry : this.disabledEntitySpawns) {
            ResourceLocation entityRegistryName = EntityList.func_191306_a((Class)entry.field_76300_b);
            if (entityRegistryName == null) continue;
            Config entityConfig = JsonFormat.newConfig(LinkedHashMap::new);
            entityConfig.add("entity", (Object)entityRegistryName.toString());
            entityConfig.add("spawnWeight", (Object)entry.field_76292_a);
            entityConfig.add("minimumGroupCount", (Object)entry.field_76301_c);
            entityConfig.add("maximumGroupCount", (Object)entry.field_76299_d);
            entityConfigs.add(entityConfig);
        }
        config.set("entities", entityConfigs);
        ArrayList<Config> arrayList = new ArrayList<Config>();
        for (Map.Entry<GenerationStage, List<IBiomeTrait>> entry : this.biomeTraits.entrySet()) {
            for (IBiomeTrait biomeTrait : entry.getValue()) {
                Config biomeTraitConfig = JsonFormat.newConfig(LinkedHashMap::new);
                biomeTrait.writeToConfig(biomeTraitConfig);
                biomeTraitConfig.add("generationStage", (Object)entry.getKey().toString());
                arrayList.add(biomeTraitConfig);
            }
        }
        config.set("traits", arrayList);
        if (!this.isSubBiome) {
            ArrayList<String> subBiomeNames = new ArrayList<String>();
            for (IBiomeData biomeData : this.subBiomes) {
                if (biomeData.getBiome().getRegistryName() == null) continue;
                subBiomeNames.add(biomeData.getBiome().getRegistryName().toString());
            }
            config.set("subBiomes", subBiomeNames);
        }
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public int getGenerationWeight() {
        return this.generationWeight;
    }

    @Override
    public boolean useDefaultBiomeDecorations() {
        return this.useDefaultDecorations;
    }

    @Override
    public boolean isSubBiome() {
        return this.isSubBiome;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public IBlockState getBiomeBlock(BiomeBlockType biomeBlock) {
        return this.biomeBlocks.get((Object)biomeBlock);
    }

    @Override
    public Map<BiomeBlockType, IBlockState> getBiomeBlocks() {
        return this.biomeBlocks;
    }

    @Override
    public List<IBiomeTrait> getBiomeTraits(GenerationStage generationStage) {
        return this.biomeTraits.computeIfAbsent(generationStage, k -> new ArrayList());
    }

    @Override
    public List<Biome.SpawnListEntry> getEntitySpawns(EnumCreatureType creatureType) {
        return this.entitySpawns.computeIfAbsent(creatureType, k -> new ArrayList());
    }

    @Override
    public List<IBiomeData> getSubBiomes() {
        return this.subBiomes;
    }
}

