/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitAbstractTree;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BiomeTraitBasicTree
extends BiomeTraitAbstractTree {
    protected BiomeTraitBasicTree(Builder builder) {
        super(builder);
        this.logBlock = builder.logBlock;
        this.leafBlock = builder.leafBlock;
        this.blockToTarget = builder.blockToTarget;
        this.minimumGrowthHeight = builder.minimumGrowthHeight;
        this.maximumGrowthHeight = builder.maximumGrowthHeight;
    }

    public static BiomeTraitBasicTree create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        int height = RandomHelper.getNumberInRange(this.minimumGrowthHeight, this.maximumGrowthHeight, random);
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.func_72800_K()) {
            for (int posY = pos.func_177956_o(); posY <= pos.func_177956_o() + 1 + height; ++posY) {
                int adjustedHeight = 1;
                if (posY == pos.func_177956_o()) {
                    adjustedHeight = 0;
                }
                if (posY >= pos.func_177956_o() + 1 + height - 2) {
                    adjustedHeight = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int posX = pos.func_177958_n() - adjustedHeight; posX <= pos.func_177958_n() + adjustedHeight && flag; ++posX) {
                    for (int posZ = pos.func_177952_p() - adjustedHeight; posZ <= pos.func_177952_p() + adjustedHeight && flag; ++posZ) {
                        if (posY >= 0 && posY < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)mutablePos.func_181079_c(posX, posY, posZ))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState checkState = world.func_180495_p(pos.func_177977_b());
            if (this.blockToTarget == checkState && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                checkState.func_177230_c().onPlantGrow(checkState, world, pos.func_177977_b(), pos);
                for (int checkPosY = pos.func_177956_o() - 3 + height; checkPosY <= pos.func_177956_o() + height; ++checkPosY) {
                    int i4 = checkPosY - (pos.func_177956_o() + height);
                    int j1 = 1 - i4 / 2;
                    for (int checkPosX = pos.func_177958_n() - j1; checkPosX <= pos.func_177958_n() + j1; ++checkPosX) {
                        int l1 = checkPosX - pos.func_177958_n();
                        for (int checkPosZ = pos.func_177952_p() - j1; checkPosZ <= pos.func_177952_p() + j1; ++checkPosZ) {
                            BlockPos checkPos;
                            int j2 = checkPosZ - pos.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (random.nextInt(2) == 0 || i4 == 0) || !(checkState = world.func_180495_p(checkPos = new BlockPos(checkPosX, checkPosY, checkPosZ))).func_177230_c().isAir(checkState, (IBlockAccess)world, checkPos) && !checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, checkPos) && checkState.func_185904_a() != Material.field_151582_l) continue;
                            world.func_175656_a(checkPos, this.leafBlock);
                        }
                    }
                }
                for (int heightOffset = 0; heightOffset < height; ++heightOffset) {
                    BlockPos offsetPos = pos.func_177981_b(heightOffset);
                    checkState = world.func_180495_p(offsetPos);
                    if (!checkState.func_177230_c().isAir(checkState, (IBlockAccess)world, offsetPos) && !checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, offsetPos) && checkState.func_185904_a() != Material.field_151582_l) continue;
                    world.func_175656_a(pos.func_177981_b(heightOffset), this.logBlock);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static class Builder
    extends BiomeTraitAbstractTree.Builder {
        @Override
        public BiomeTraitBasicTree create() {
            return new BiomeTraitBasicTree(this);
        }
    }
}

