/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeTraitCluster
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToAttachTo;
    protected EnumFacing direction;

    protected BiomeTraitCluster(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToAttachTo = builder.blockToAttachTo;
        this.direction = builder.direction;
    }

    public static BiomeTraitCluster create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToAttachTo = ConfigHelper.getBlockState(config, "blockToAttachTo");
        this.direction = (EnumFacing)config.getEnumOrElse("direction", (Enum)EnumFacing.DOWN);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        config.add("direction", this.direction == null ? null : this.direction.toString().toLowerCase());
        ConfigHelper.setBlockState(config, "blockToAttachTo", this.blockToAttachTo);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToAttachTo == null || this.direction == null) {
            return false;
        }
        if (!world.func_175623_d(pos)) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(this.direction.func_176734_d())) != this.blockToAttachTo) {
            return false;
        }
        world.func_180501_a(pos, this.blockToSpawn, 3);
        for (int i = 0; i < 1500; ++i) {
            BlockPos newPos;
            switch (this.direction) {
                default: {
                    newPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), -random.nextInt(12), random.nextInt(8) - random.nextInt(8));
                    break;
                }
                case UP: {
                    newPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(12), random.nextInt(8) - random.nextInt(8));
                    break;
                }
                case NORTH: {
                    newPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8), -random.nextInt(12));
                    break;
                }
                case SOUTH: {
                    newPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8), random.nextInt(12));
                    break;
                }
                case WEST: {
                    newPos = pos.func_177982_a(-random.nextInt(12), random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8));
                    break;
                }
                case EAST: {
                    newPos = pos.func_177982_a(random.nextInt(12), random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8));
                }
            }
            if (!world.func_175623_d(newPos)) continue;
            int adjacentBlocks = 0;
            for (EnumFacing facing : EnumFacing.values()) {
                if (world.func_180495_p(newPos.func_177972_a(facing)).func_177230_c() == this.blockToSpawn.func_177230_c()) {
                    ++adjacentBlocks;
                }
                if (adjacentBlocks > 1) break;
            }
            if (adjacentBlocks != true) continue;
            world.func_180501_a(newPos, this.blockToSpawn, 3);
        }
        return true;
    }

    public static class Builder
    extends BiomeTrait.Builder {
        private IBlockState blockToSpawn = Blocks.field_150426_aN.func_176223_P();
        private IBlockState blockToAttachTo = Blocks.field_150424_aL.func_176223_P();
        private EnumFacing direction = EnumFacing.DOWN;

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToAttachTo(IBlockState blockToAttachTo) {
            this.blockToAttachTo = blockToAttachTo;
            return this;
        }

        public Builder direction(EnumFacing direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public BiomeTraitCluster create() {
            return new BiomeTraitCluster(this);
        }
    }
}

