/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitAbstractTree;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BiomeTraitSparseTree
extends BiomeTraitAbstractTree {
    protected BiomeTraitSparseTree(Builder builder) {
        super(builder);
        this.logBlock = builder.logBlock;
        this.leafBlock = builder.leafBlock;
        this.blockToTarget = builder.blockToTarget;
        this.minimumGrowthHeight = builder.minimumGrowthHeight;
        this.maximumGrowthHeight = builder.maximumGrowthHeight;
    }

    public static BiomeTraitSparseTree create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.logBlock == null || this.leafBlock == null) {
            return false;
        }
        int height = RandomHelper.getNumberInRange(this.minimumGrowthHeight, this.maximumGrowthHeight, random);
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int posY = pos.func_177956_o(); posY <= pos.func_177956_o() + 1 + height; ++posY) {
                int adjustedHeight = 1;
                if (posY == pos.func_177956_o()) {
                    adjustedHeight = 0;
                }
                if (posY >= pos.func_177956_o() + 1 + height - 2) {
                    adjustedHeight = 2;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int posX = pos.func_177958_n() - adjustedHeight; posX <= pos.func_177958_n() + adjustedHeight && flag; ++posX) {
                    for (int posZ = pos.func_177952_p() - adjustedHeight; posZ <= pos.func_177952_p() + adjustedHeight && flag; ++posZ) {
                        if (posY >= 0 && posY < 256) {
                            if (this.isReplaceable(world, (BlockPos)mutableBlockPos.func_181079_c(posX, posY, posZ))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos downPos = pos.func_177977_b();
            IBlockState state = world.func_180495_p(downPos);
            if (this.blockToTarget == state && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                int posXLeaf;
                state.func_177230_c().onPlantGrow(state, world, downPos, pos);
                EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                int adjustedHeight = height - random.nextInt(4) - 1;
                int bonusHeight = 3 - random.nextInt(3);
                int posXOffset = pos.func_177958_n();
                int posZOffset = pos.func_177952_p();
                int posYOffset = 0;
                for (int localHeight = 0; localHeight < height; ++localHeight) {
                    BlockPos offsetPos;
                    int adjustedLocalHeight = pos.func_177956_o() + localHeight;
                    if (localHeight >= adjustedHeight && bonusHeight > 0) {
                        posXOffset += facing.func_82601_c();
                        posZOffset += facing.func_82599_e();
                        --bonusHeight;
                    }
                    if (!(state = world.func_180495_p(offsetPos = new BlockPos(posXOffset, adjustedLocalHeight, posZOffset))).func_177230_c().isAir(state, (IBlockAccess)world, offsetPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, offsetPos)) continue;
                    this.placeLogAt(world, offsetPos);
                    posYOffset = adjustedLocalHeight;
                }
                BlockPos posLeaf = new BlockPos(posXOffset, posYOffset, posZOffset);
                for (posXLeaf = -3; posXLeaf <= 3; ++posXLeaf) {
                    for (int posZLeaf = -3; posZLeaf <= 3; ++posZLeaf) {
                        if (Math.abs(posXLeaf) == 3 && Math.abs(posZLeaf) == 3) continue;
                        this.placeLeafAt(world, posLeaf.func_177982_a(posXLeaf, 0, posZLeaf));
                    }
                }
                posLeaf = posLeaf.func_177984_a();
                for (posXLeaf = -1; posXLeaf <= 1; ++posXLeaf) {
                    for (int posZLeaf = -1; posZLeaf <= 1; ++posZLeaf) {
                        this.placeLeafAt(world, posLeaf.func_177982_a(posXLeaf, 0, posZLeaf));
                    }
                }
                this.placeLeafAt(world, posLeaf.func_177965_g(2));
                this.placeLeafAt(world, posLeaf.func_177985_f(2));
                this.placeLeafAt(world, posLeaf.func_177970_e(2));
                this.placeLeafAt(world, posLeaf.func_177964_d(2));
                posXOffset = pos.func_177958_n();
                posZOffset = pos.func_177952_p();
                EnumFacing horizontalFacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                if (horizontalFacing != facing) {
                    int randomAdjustedHeight = adjustedHeight - random.nextInt(2) - 1;
                    int randomHeight = 1 + random.nextInt(3);
                    posYOffset = 0;
                    for (int localRandomHeight = randomAdjustedHeight; localRandomHeight < height && randomHeight > 0; ++localRandomHeight, --randomHeight) {
                        if (localRandomHeight < 1) continue;
                        int posYLog = pos.func_177956_o() + localRandomHeight;
                        BlockPos posLog = new BlockPos(posXOffset += horizontalFacing.func_82601_c(), posYLog, posZOffset += horizontalFacing.func_82599_e());
                        state = world.func_180495_p(posLog);
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, posLog) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, posLog)) continue;
                        this.placeLogAt(world, posLog);
                        posYOffset = posYLog;
                    }
                    if (posYOffset > 0) {
                        int posXLeaf2;
                        BlockPos posOffset = new BlockPos(posXOffset, posYOffset, posZOffset);
                        for (posXLeaf2 = -2; posXLeaf2 <= 2; ++posXLeaf2) {
                            for (int posZLeaf = -2; posZLeaf <= 2; ++posZLeaf) {
                                if (Math.abs(posXLeaf2) == 2 && Math.abs(posZLeaf) == 2) continue;
                                this.placeLeafAt(world, posOffset.func_177982_a(posXLeaf2, 0, posZLeaf));
                            }
                        }
                        posOffset = posOffset.func_177984_a();
                        for (posXLeaf2 = -1; posXLeaf2 <= 1; ++posXLeaf2) {
                            for (int posZLeaf = -1; posZLeaf <= 1; ++posZLeaf) {
                                this.placeLeafAt(world, posOffset.func_177982_a(posXLeaf2, 0, posZLeaf));
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLeafAt(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            world.func_175656_a(pos, this.leafBlock);
        }
    }

    public static class Builder
    extends BiomeTraitAbstractTree.Builder {
        @Override
        public BiomeTraitSparseTree create() {
            return new BiomeTraitSparseTree(this);
        }
    }
}

