/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MazePredicateMany<C>
implements MazePredicate<C> {
    public final List<MazePredicate<C>> predicates = new ArrayList<MazePredicate<C>>();

    public MazePredicateMany() {
    }

    public MazePredicateMany(List<MazePredicate<C>> predicates) {
        this.predicates.addAll(predicates);
    }

    @SafeVarargs
    public MazePredicateMany(MazePredicate<C> ... predicates) {
        Collections.addAll(this.predicates, predicates);
    }

    @Override
    public boolean canPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        return this.predicates.stream().allMatch(p -> p.canPlace(maze, component));
    }

    @Override
    public void willPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.predicates.forEach(p -> p.willPlace(maze, component));
    }

    @Override
    public void didPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.predicates.forEach(p -> p.didPlace(maze, component));
    }

    @Override
    public void willUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.predicates.forEach(p -> p.willUnplace(maze, component));
    }

    @Override
    public void didUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.predicates.forEach(p -> p.didUnplace(maze, component));
    }

    @Override
    public boolean isDirtyConnection(MazeRoom dest, MazeRoom source, C c) {
        return this.predicates.stream().allMatch(p -> p.isDirtyConnection(dest, source, c));
    }
}

