/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche;

import java.util.Arrays;
import java.util.Locale;
import landmaster.cartblanche.config.Config;
import landmaster.cartblanche.entity.EntityBannerCart;
import landmaster.cartblanche.entity.EntityBeaconCart;
import landmaster.cartblanche.entity.EntityEnderChestCart;
import landmaster.cartblanche.entity.EntityIronChestCart;
import landmaster.cartblanche.entity.EntityJukeboxCart;
import landmaster.cartblanche.entity.EntityNetherChestCart;
import landmaster.cartblanche.gui.CBGuiHandler;
import landmaster.cartblanche.item.ItemModMinecart;
import landmaster.cartblanche.item.ModItems;
import landmaster.cartblanche.net.PacketUpdateTopStacks;
import landmaster.cartblanche.proxy.CommonProxy;
import landmaster.cartblanche.util.BannerCartRecipe;
import landmaster.cartblanche.util.BeaconCartLevelRecipe;
import landmaster.cartblanche.util.IronChestStuff;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="cartblanche", name="Cart Blanche", version="1.0.6.5", dependencies="after:jei@[4.13,);after:ironchest;", useMetadata=true, acceptedMinecraftVersions="[1.12, 1.13)")
public class CartBlanche {
    public static Config config;
    @Mod.Instance(value="cartblanche")
    public static CartBlanche INSTANCE;
    @SidedProxy(serverSide="landmaster.cartblanche.proxy.CommonProxy", clientSide="landmaster.cartblanche.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static final Logger log;
    public static final SimpleNetworkWrapper HANDLER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Config(event);
        config.init();
        config.update();
        if (Config.ender_chest_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "ender_chest_cart"), EntityEnderChestCart.class, (String)"EnderChestCart", (int)0, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        if (Config.jukebox_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "jukebox_cart"), EntityJukeboxCart.class, (String)"JukeboxCart", (int)1, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        if (Config.beacon_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "beacon_cart"), EntityBeaconCart.class, (String)"BeaconCart", (int)2, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        if (Config.iron_chest_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "iron_chest_cart"), EntityIronChestCart.class, (String)"IronChestCart", (int)3, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        if (Config.nether_chest_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "nether_chest_cart"), EntityNetherChestCart.class, (String)"NetherChestCart", (int)4, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        if (Config.banner_cart) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cartblanche", "banner_cart"), EntityBannerCart.class, (String)"BannerCart", (int)5, (Object)INSTANCE, (int)256, (int)2, (boolean)true);
        }
        proxy.initEntityRendering();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new CBGuiHandler());
        if (Loader.isModLoaded((String)"ironchest")) {
            HANDLER.registerMessage(PacketUpdateTopStacks::onMessage, PacketUpdateTopStacks.class, 0, Side.CLIENT);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModItems.mod_minecart);
        for (ItemModMinecart.Type type : ItemModMinecart.Type.values()) {
            if (!type.config.getAsBoolean()) continue;
            if (type == ItemModMinecart.Type.IRON_CHEST) {
                proxy.registerItemRenderer((Item)ModItems.mod_minecart, stack -> {
                    if (stack.func_77960_j() == ItemModMinecart.Type.IRON_CHEST.ordinal()) {
                        return new ModelResourceLocation("cartblanche:mod_minecart_iron_chest_" + ModItems.mod_minecart.getIronChestTypeString((ItemStack)stack).toLowerCase(Locale.US));
                    }
                    return null;
                }, (ResourceLocation[])Arrays.stream(IronChestStuff.getIronChestTypes()).mapToObj(typeInt -> new ModelResourceLocation("cartblanche:mod_minecart_iron_chest_" + IronChestStuff.ironChestStringFromInt(typeInt).toLowerCase(Locale.US))).toArray(ModelResourceLocation[]::new));
                continue;
            }
            proxy.registerItemRenderer((Item)ModItems.mod_minecart, type.ordinal(), "mod_minecart_" + type.toString().toLowerCase(Locale.US));
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (Config.beacon_cart) {
            for (int i = 1; i <= 8; ++i) {
                event.getRegistry().register((IForgeRegistryEntry)new BeaconCartLevelRecipe(i));
            }
        }
        if (Config.banner_cart) {
            event.getRegistry().register((IForgeRegistryEntry)new BannerCartRecipe());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        log = LogManager.getLogger((String)"cartblanche".toUpperCase(Locale.US));
        HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("cartblanche");
    }
}

