/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import landmaster.cartblanche.util.DataSerializerArray;
import landmaster.cartblanche.util.DataSerializerEnum;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityBannerCart
extends EntityMinecart {
    private static final DataParameter<Integer> ROTATION = EntityDataManager.func_187226_a(EntityBannerCart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<EnumDyeColor> BASE_COLOR = EntityDataManager.func_187226_a(EntityBannerCart.class, DataSerializerEnum.DYE_COLOR);
    private static final DataParameter<NBTTagCompound[]> PATTERNS = EntityDataManager.func_187226_a(EntityBannerCart.class, DataSerializerArray.COMPOUND_TAG);
    private List<BannerPattern> patternList;
    private List<EnumDyeColor> colorList;
    private String patternResourceLocation;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ROTATION, (Object)0);
        this.func_184212_Q().func_187214_a(BASE_COLOR, (Object)EnumDyeColor.BLACK);
        this.func_184212_Q().func_187214_a(PATTERNS, (Object)new NBTTagCompound[0]);
    }

    public EntityBannerCart(World worldIn) {
        super(worldIn);
    }

    public EntityBannerCart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityBannerCart setBaseColor(EnumDyeColor color) {
        this.func_184212_Q().func_187227_b(BASE_COLOR, (Object)color);
        return this;
    }

    public EntityBannerCart setPatterns(NBTTagCompound[] patterns) {
        this.func_184212_Q().func_187227_b(PATTERNS, (Object)patterns);
        return this;
    }

    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    public ItemStack getBannerItem() {
        ItemStack stack = ItemBanner.func_190910_a((EnumDyeColor)((EnumDyeColor)this.func_184212_Q().func_187225_a(BASE_COLOR)), (NBTTagList)Arrays.stream((Object[])this.func_184212_Q().func_187225_a(PATTERNS)).collect(NBTTagList::new, NBTTagList::func_74742_a, (list0, list1) -> list1.forEach(arg_0 -> ((NBTTagList)list0).func_74742_a(arg_0))));
        return stack;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(this.getBannerItem(), 0.0f);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Rotation", ((Integer)this.func_184212_Q().func_187225_a(ROTATION)).intValue());
        compound.func_74768_a("Base", ((EnumDyeColor)this.func_184212_Q().func_187225_a(BASE_COLOR)).func_176767_b());
        compound.func_74782_a("Patterns", (NBTBase)Arrays.stream((Object[])this.func_184212_Q().func_187225_a(PATTERNS)).collect(NBTTagList::new, NBTTagList::func_74742_a, (list0, list1) -> list1.forEach(arg_0 -> ((NBTTagList)list0).func_74742_a(arg_0))));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(ROTATION, (Object)compound.func_74762_e("Rotation"));
        this.func_184212_Q().func_187227_b(BASE_COLOR, (Object)EnumDyeColor.func_176766_a((int)compound.func_74762_e("Base")));
        this.func_184212_Q().func_187227_b(PATTERNS, (Object)Iterables.toArray((Iterable)compound.func_150295_c("Patterns", 10), NBTTagCompound.class));
    }

    public IBlockState func_180457_u() {
        return Blocks.field_180393_cK.func_176223_P().func_177226_a((IProperty)BlockBanner.field_176448_b, (Comparable)this.func_184212_Q().func_187225_a(ROTATION));
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(ROTATION, (Object)(((Integer)this.func_184212_Q().func_187225_a(ROTATION) + 1) % 16));
        }
        return true;
    }

    public int getRotation() {
        return (Integer)this.func_184212_Q().func_187225_a(ROTATION);
    }

    public List<BannerPattern> getPatternList() {
        this.initializeBannerData();
        return this.patternList;
    }

    public List<EnumDyeColor> getColorList() {
        this.initializeBannerData();
        return this.colorList;
    }

    public String getPatternResourceLocation() {
        this.initializeBannerData();
        return this.patternResourceLocation;
    }

    private void initializeBannerData() {
        if (this.patternList == null || this.colorList == null || this.patternResourceLocation == null) {
            this.patternList = Lists.newArrayList();
            this.colorList = Lists.newArrayList();
            this.patternList.add(BannerPattern.BASE);
            this.colorList.add((EnumDyeColor)this.func_184212_Q().func_187225_a(BASE_COLOR));
            this.patternResourceLocation = "b" + ((EnumDyeColor)this.func_184212_Q().func_187225_a(BASE_COLOR)).func_176767_b();
            NBTTagCompound[] patterns = (NBTTagCompound[])this.func_184212_Q().func_187225_a(PATTERNS);
            for (int i = 0; i < patterns.length; ++i) {
                NBTTagCompound nbttagcompound = patterns[i];
                BannerPattern bannerpattern = BannerPattern.func_190994_a((String)nbttagcompound.func_74779_i("Pattern"));
                if (bannerpattern == null) continue;
                this.patternList.add(bannerpattern);
                int j = nbttagcompound.func_74762_e("Color");
                this.colorList.add(EnumDyeColor.func_176766_a((int)j));
                this.patternResourceLocation = this.patternResourceLocation + bannerpattern.func_190993_b() + j;
            }
        }
    }
}

