/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import landmaster.cartblanche.entity.EntityJukeboxCart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class EntityBeaconCart
extends EntityMinecartContainer
implements ISidedInventory {
    private List<ItemStack> beaconMaterials = new ArrayList<ItemStack>();
    private final List<TileEntityBeacon.BeamSegment> beamSegments = new ArrayList<TileEntityBeacon.BeamSegment>();
    private long beamRenderCounter;
    private float beamRenderScale;
    private Potion primaryEffect;
    private Potion secondaryEffect;
    private boolean isComplete;
    private static final DataParameter<Integer> LEVELS = EntityDataManager.func_187226_a(EntityJukeboxCart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int LEVELS_UNINIT = 127;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVELS, (Object)127);
    }

    public EntityBeaconCart(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
    }

    public EntityBeaconCart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.field_70158_ak = true;
    }

    public EntityBeaconCart setBeaconMaterials(List<ItemStack> beaconMaterials) {
        this.beaconMaterials = beaconMaterials;
        return this;
    }

    public int getLevels() {
        if ((Integer)this.func_184212_Q().func_187225_a(LEVELS) == 127) {
            int levels = -1;
            int len = 0;
            while ((len += (2 * ++levels + 3) * (2 * levels + 3)) <= this.beaconMaterials.size()) {
            }
            this.func_184212_Q().func_187227_b(LEVELS, (Object)Math.min(levels, 4));
        }
        return (Integer)this.func_184212_Q().func_187225_a(LEVELS);
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150461_bJ), 1, 0.0f);
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
            for (ItemStack stack : this.beaconMaterials) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)stack);
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBeacon((IInventory)playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "minecraft:beacon";
    }

    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    public IBlockState func_180457_u() {
        return Blocks.field_150461_bJ.func_176223_P();
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.primaryEffect = TileEntityBeacon.func_184279_f((int)compound.func_74762_e("Primary"));
        this.secondaryEffect = TileEntityBeacon.func_184279_f((int)compound.func_74762_e("Secondary"));
        compound.func_150295_c("BeaconMaterials", 10).forEach(stackNBT -> this.beaconMaterials.add(new ItemStack((NBTTagCompound)stackNBT)));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Primary", Potion.func_188409_a((Potion)this.primaryEffect));
        compound.func_74768_a("Secondary", Potion.func_188409_a((Potion)this.secondaryEffect));
        compound.func_74782_a("BeaconMaterials", (NBTBase)this.beaconMaterials.stream().map(ItemStack::serializeNBT).collect(NBTTagList::new, NBTTagList::func_74742_a, (list0, list1) -> list1.forEach(arg_0 -> ((NBTTagList)list0).func_74742_a(arg_0))));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() != null && stack.func_77973_b().isBeaconPayment(stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getLevels();
            }
            case 1: {
                return Potion.func_188409_a((Potion)this.primaryEffect);
            }
            case 2: {
                return Potion.func_188409_a((Potion)this.secondaryEffect);
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                break;
            }
            case 1: {
                this.primaryEffect = TileEntityBeacon.func_184279_f((int)value);
                break;
            }
            case 2: {
                this.secondaryEffect = TileEntityBeacon.func_184279_f((int)value);
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_82737_E() % 80L == 0L) {
            this.updateBeacon();
        }
    }

    public void updateBeacon() {
        this.updateSegmentColors();
        this.addEffectsToPlayers();
    }

    private void addEffectsToPlayers() {
        if (this.isComplete && this.getLevels() > 0 && !this.field_70170_p.field_72995_K && this.primaryEffect != null) {
            double d0 = this.getLevels() * 10 + 10;
            int i = 0;
            if (this.getLevels() >= 4 && this.primaryEffect == this.secondaryEffect) {
                i = 1;
            }
            int j = (9 + this.getLevels() * 2) * 20;
            double k = this.field_70165_t;
            double l = this.field_70163_u;
            double i1 = this.field_70161_v;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(k, l, i1, k + 1.0, l + 1.0, i1 + 1.0).func_186662_g(d0).func_72321_a(0.0, (double)this.field_70170_p.func_72800_K(), 0.0);
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
            for (EntityPlayer entityplayer : list) {
                entityplayer.func_70690_d(new PotionEffect(this.primaryEffect, j, i, true, true));
            }
            if (this.getLevels() >= 4 && this.primaryEffect != this.secondaryEffect && this.secondaryEffect != null) {
                for (EntityPlayer entityplayer1 : list) {
                    entityplayer1.func_70690_d(new PotionEffect(this.secondaryEffect, j, 0, true, true));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSegmentColors() {
        double i = this.field_70165_t;
        double j = this.field_70163_u;
        double k = this.field_70161_v;
        this.beamSegments.clear();
        this.isComplete = true;
        TileEntityBeacon.BeamSegment tileentitybeacon$beamsegment = new TileEntityBeacon.BeamSegment(EnumDyeColor.WHITE.func_193349_f());
        this.beamSegments.add(tileentitybeacon$beamsegment);
        boolean flag = true;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i1 = (int)(j + 0.5) + 1; i1 < 256; ++i1) {
            float[] afloat;
            block11: {
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_189532_c(i, (double)i1, k));
                if (iblockstate.func_177230_c() == Blocks.field_150399_cn) {
                    afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_193349_f();
                } else {
                    if (iblockstate.func_177230_c() != Blocks.field_150397_co) {
                        if (iblockstate.getLightOpacity((IBlockAccess)this.field_70170_p, (BlockPos)blockpos$mutableblockpos) >= 15 && iblockstate.func_177230_c() != Blocks.field_150357_h) {
                            this.isComplete = false;
                            this.beamSegments.clear();
                            break;
                        }
                        float[] customColor = iblockstate.func_177230_c().getBeaconColorMultiplier(iblockstate, this.field_70170_p, (BlockPos)blockpos$mutableblockpos, this.func_180425_c());
                        if (customColor != null) {
                            afloat = customColor;
                            break block11;
                        } else {
                            tileentitybeacon$beamsegment.func_177262_a();
                            continue;
                        }
                    }
                    afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).func_193349_f();
                }
            }
            if (!flag) {
                afloat = new float[]{(tileentitybeacon$beamsegment.func_177263_b()[0] + afloat[0]) / 2.0f, (tileentitybeacon$beamsegment.func_177263_b()[1] + afloat[1]) / 2.0f, (tileentitybeacon$beamsegment.func_177263_b()[2] + afloat[2]) / 2.0f};
            }
            if (Arrays.equals(afloat, tileentitybeacon$beamsegment.func_177263_b())) {
                tileentitybeacon$beamsegment.func_177262_a();
            } else {
                tileentitybeacon$beamsegment = new TileEntityBeacon.BeamSegment(afloat);
                this.beamSegments.add(tileentitybeacon$beamsegment);
            }
            flag = false;
        }
        if (this.getLevels() == 0) {
            this.isComplete = false;
        }
    }

    public List<TileEntityBeacon.BeamSegment> getBeamSegments() {
        return this.beamSegments;
    }

    public float shouldBeamRender() {
        if (!this.isComplete) {
            return 0.0f;
        }
        int i = (int)(this.field_70170_p.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_70170_p.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

