/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.entity;

import com.google.common.base.Throwables;
import cpw.mods.ironchest.common.blocks.chest.BlockIronChest;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.core.IronChestBlocks;
import cpw.mods.ironchest.common.gui.chest.ContainerIronChest;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import landmaster.cartblanche.CartBlanche;
import landmaster.cartblanche.entity.EntityJukeboxCart;
import landmaster.cartblanche.net.PacketUpdateTopStacks;
import landmaster.cartblanche.util.IronChestStuff;
import landmaster.cartblanche.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityIronChestCart
extends EntityMinecartContainer {
    private static final DataParameter<Integer> IRON_CHEST_TYPE = EntityDataManager.func_187226_a(EntityJukeboxCart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int IRON_CHEST_TYPE_UNINIT = 127;
    private boolean invTouched;
    private List<ItemStack> topStacks;
    private static final int MAX_IRON_CHEST_SIZE = Arrays.stream(IronChestStuff.getIronChestTypes()).mapToObj(val -> IronChestType.VALUES[val]).mapToInt(ch -> ch.size).max().orElse(0);
    private static final MethodHandle setDeadHandle;
    private static final MethodHandle processInitialInteractHandle;
    private boolean hadStuff;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IRON_CHEST_TYPE, (Object)127);
    }

    public EntityIronChestCart(World worldIn) {
        super(worldIn);
        this.init();
    }

    public EntityIronChestCart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.init();
    }

    private void init() {
        this.field_94113_a = NonNullList.func_191197_a((int)MAX_IRON_CHEST_SIZE, (Object)ItemStack.field_190927_a);
        this.topStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_70301_a(int index) {
        this.invTouched = true;
        return super.func_70301_a(index);
    }

    public EntityIronChestCart setChestType(int type) {
        this.func_184212_Q().func_187227_b(IRON_CHEST_TYPE, (Object)type);
        return this;
    }

    public EntityIronChestCart setChestType(IronChestType type) {
        return this.setChestType(type.ordinal());
    }

    public IronChestType getChestType() {
        int val = (Integer)this.func_184212_Q().func_187225_a(IRON_CHEST_TYPE);
        if (val == 127) {
            return null;
        }
        return IronChestType.VALUES[val];
    }

    public int func_70302_i_() {
        IronChestType type = this.getChestType();
        if (type == null) {
            return MAX_IRON_CHEST_SIZE;
        }
        return this.getChestType().size;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184288_f(playerIn);
        IronChestType type = this.getChestType();
        return new ContainerIronChest((IInventory)playerInventory, (IInventory)this, type, type.xSize, type.ySize);
    }

    public String func_174875_k() {
        return null;
    }

    @Deprecated
    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack((Block)IronChestBlocks.ironChestBlock, 1, this.getChestType().ordinal()), 0.0f);
        }
    }

    public void func_70106_y() {
        try {
            setDeadHandle.invokeExact(this);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        if (!this.field_70170_p.field_72995_K && this.field_94112_b) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
    }

    public IBlockState func_180457_u() {
        return IronChestBlocks.ironChestBlock.func_176223_P().func_177226_a((IProperty)BlockIronChest.VARIANT_PROP, (Comparable)this.getChestType());
    }

    public int func_94085_r() {
        return 8;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        try {
            if (processInitialInteractHandle.invokeExact(this, player, hand)) {
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)CartBlanche.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(IRON_CHEST_TYPE, (Object)compound.func_74762_e("IronChestType"));
        this.sortTopStacks();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("IronChestType", ((Integer)this.func_184212_Q().func_187225_a(IRON_CHEST_TYPE)).intValue());
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + "." + this.getChestType().name().toLowerCase(Locale.US) + ".name"));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    public List<ItemStack> getTopStacks() {
        return this.topStacks;
    }

    protected void sortTopStacks() {
        int i;
        if (!this.getChestType().isTransparent() || this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            return;
        }
        NonNullList tempCopy = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.func_185132_d((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.func_190916_E() == tempCopyStack.func_190916_E()) continue block0;
                tempCopyStack.func_190917_f(itemStack.func_190916_E());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.func_77946_l());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.topStacks.size(); ++i) {
                this.topStacks.set(i, ItemStack.field_190927_a);
            }
            return;
        }
        this.hadStuff = true;
        Collections.sort(tempCopy, (stack1, stack2) -> {
            if (stack1.func_190926_b()) {
                return 1;
            }
            if (stack2.func_190926_b()) {
                return -1;
            }
            return stack2.func_190916_E() - stack1.func_190916_E();
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.func_190926_b() || element.func_190916_E() <= 0) continue;
            if (p == this.topStacks.size()) break;
            this.topStacks.set(p, element);
            ++p;
        }
        for (int i2 = p; i2 < this.topStacks.size(); ++i2) {
            this.topStacks.set(i2, ItemStack.field_190927_a);
        }
        this.sendTopStacksPacket();
    }

    public void setTopStacks(List<ItemStack> stacks) {
        this.topStacks = stacks;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.invTouched) {
            this.invTouched = false;
            this.sortTopStacks();
        }
    }

    protected void sendTopStacksPacket() {
        CartBlanche.HANDLER.sendToAllAround((IMessage)new PacketUpdateTopStacks(this.func_145782_y(), this.topStacks), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
    }

    static {
        try {
            setDeadHandle = Utils.IMPL_LOOKUP.findSpecial(EntityMinecart.class, "func_70106_y", MethodType.methodType(Void.TYPE), EntityMinecartContainer.class);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            processInitialInteractHandle = Utils.IMPL_LOOKUP.findSpecial(EntityMinecart.class, "func_184230_a", MethodType.methodType(Boolean.TYPE, EntityPlayer.class, EnumHand.class), EntityMinecartContainer.class);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

