/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.entity;

import com.google.common.collect.MapMaker;
import java.util.Map;
import javax.annotation.Nonnull;
import landmaster.cartblanche.CartBlanche;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityJukeboxCart
extends EntityMinecart {
    private ItemStackHandler record = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemRecord;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private static final DataParameter<Boolean> DISABLED = EntityDataManager.func_187226_a(EntityJukeboxCart.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Map<Integer, Object> soundMap = new MapMaker().weakValues().makeMap();

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DISABLED, (Object)false);
    }

    public EntityJukeboxCart(World worldIn) {
        super(worldIn);
    }

    public EntityJukeboxCart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        this.func_184212_Q().func_187227_b(DISABLED, (Object)receivingPower);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(DISABLED, (Object)compound.func_74767_n("Disabled"));
        this.record.deserializeNBT(compound.func_74775_l("Record"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Disabled", ((Boolean)this.func_184212_Q().func_187225_a(DISABLED)).booleanValue());
        compound.func_74782_a("Record", (NBTBase)this.record.serializeNBT());
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand).func_77946_l();
        if (!stack.func_190926_b()) {
            if (this.record.isItemValid(0, stack)) {
                ItemStack newStack = this.record.insertItem(0, stack, false);
                player.func_184611_a(hand, newStack);
                return !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)newStack);
            }
        } else {
            stack = this.record.extractItem(0, 1, false);
            player.func_184611_a(hand, stack);
            return !stack.func_190926_b();
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.record;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public boolean isDisabled() {
        return (Boolean)this.func_184212_Q().func_187225_a(DISABLED);
    }

    public void removeSound(Object sound) {
        soundMap.remove(this.func_145782_y(), sound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70071_h_() {
        super.func_70071_h_();
        Map<Integer, Object> map = soundMap;
        synchronized (map) {
            if (this.field_70170_p.field_72995_K) {
                ItemStack stack = this.record.getStackInSlot(0);
                if (!((Boolean)this.func_184212_Q().func_187225_a(DISABLED)).booleanValue() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemRecord && !soundMap.containsKey(this.func_145782_y())) {
                    Object sound = CartBlanche.proxy.playJukeboxCartSound(((ItemRecord)stack.func_77973_b()).func_185075_h(), SoundCategory.RECORDS, this);
                    soundMap.put(this.func_145782_y(), sound);
                }
            }
        }
    }

    public IBlockState func_180457_u() {
        return Blocks.field_150421_aI.func_176223_P();
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150421_aI), 1, 0.0f);
            this.func_70099_a(this.record.getStackInSlot(0), 0.0f);
        }
    }
}

