/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.entity.render;

import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import java.util.Random;
import landmaster.cartblanche.entity.EntityIronChestCart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;

public class RenderIronChestCart
extends RenderMinecart<EntityIronChestCart> {
    private ModelChest model = new ModelChest();
    private Random random = new Random();
    private RenderEntityItem itemRenderer;
    private static final float halfPI = 1.5707964f;
    private static final float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    private static final EntityItem customitem = new EntityItem(null);

    public RenderIronChestCart(RenderManager manager) {
        super(manager);
    }

    protected void renderCartContents(EntityIronChestCart entity, float partialTicks, IBlockState p_188319_3_) {
        super.func_188319_a((EntityMinecart)entity, partialTicks, p_188319_3_);
        IronChestType type = entity.getChestType();
        this.func_110776_a(type.modelTexture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidangle = 0.0f;
        lidangle = 1.0f - lidangle;
        lidangle = 1.0f - lidangle * lidangle * lidangle;
        if (type.isTransparent()) {
            GlStateManager.func_179152_a((float)1.0f, (float)0.99f, (float)1.0f);
        }
        this.model.field_78234_a.field_78795_f = -lidangle * 1.5707964f;
        this.model.func_78231_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type.isTransparent() && entity.func_174791_d().func_72436_e(Minecraft.func_71410_x().func_175606_aa().func_174791_d()) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (entity.getTopStacks().get(1).func_190926_b()) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            customitem.func_70029_a(entity.field_70170_p);
            RenderIronChestCart.customitem.field_70290_d = 0.0f;
            for (ItemStack item : entity.getTopStacks()) {
                if (shift > shifts.length || shift > 8) break;
                if (item.func_190926_b()) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                if (this.itemRenderer == null) {
                    this.itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

                        public int func_177078_a(ItemStack stack) {
                            return SignedBytes.saturatedCast((long)(Math.min(stack.func_190916_E() / 32, 15) + 1));
                        }

                        public boolean shouldBob() {
                            return false;
                        }

                        public boolean shouldSpreadItems() {
                            return true;
                        }
                    };
                }
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }
}

