/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.item;

import com.google.common.collect.Iterables;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import landmaster.cartblanche.config.Config;
import landmaster.cartblanche.entity.EntityBannerCart;
import landmaster.cartblanche.entity.EntityBeaconCart;
import landmaster.cartblanche.entity.EntityEnderChestCart;
import landmaster.cartblanche.entity.EntityIronChestCart;
import landmaster.cartblanche.entity.EntityJukeboxCart;
import landmaster.cartblanche.entity.EntityNetherChestCart;
import landmaster.cartblanche.item.ModItems;
import landmaster.cartblanche.util.IronChestStuff;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemModMinecart
extends ItemMinecart {
    public static final int BEACON_CART_MAX_BLOCKS = 164;
    private static final IBehaviorDispenseItem MINECART_DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double d3;
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection;
            EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            World world = source.func_82618_k();
            double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c() * 1.125;
            double d1 = Math.floor(source.func_82617_b()) + (double)enumfacing.func_96559_d();
            double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e() * 1.125;
            BlockPos blockpos = source.func_180699_d().func_177972_a(enumfacing);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            BlockRailBase.EnumRailDirection enumRailDirection = blockrailbase$enumraildirection = iblockstate.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.func_177230_c()).getRailDirection((IBlockAccess)world, blockpos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            if (BlockRailBase.func_176563_d((IBlockState)iblockstate)) {
                d3 = blockrailbase$enumraildirection.func_177018_c() ? 0.6 : 0.1;
            } else {
                if (iblockstate.func_185904_a() != Material.field_151579_a || !BlockRailBase.func_176563_d((IBlockState)world.func_180495_p(blockpos.func_177977_b()))) {
                    return this.behaviourDefaultDispenseItem.func_82482_a(source, stack);
                }
                IBlockState iblockstate1 = world.func_180495_p(blockpos.func_177977_b());
                BlockRailBase.EnumRailDirection blockrailbase$enumraildirection1 = iblockstate1.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)iblockstate1.func_177230_c()).getRailDirection((IBlockAccess)world, blockpos.func_177977_b(), iblockstate1, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                d3 = enumfacing != EnumFacing.DOWN && blockrailbase$enumraildirection1.func_177018_c() ? -0.4 : -0.9;
            }
            EntityMinecart entityminecart = ((ItemModMinecart)stack.func_77973_b()).factory.create(world, d0, d1 + d3, d2, stack);
            if (stack.func_82837_s()) {
                entityminecart.func_96094_a(stack.func_82833_r());
            }
            world.func_72838_d((Entity)entityminecart);
            if (entityminecart instanceof EntityBeaconCart) {
                double i = entityminecart.field_70165_t;
                double j = entityminecart.field_70163_u;
                double k = entityminecart.field_70161_v;
                if (!world.field_72995_K && 0 < ((EntityBeaconCart)entityminecart).getLevels()) {
                    TileEntityBeacon dummy = new TileEntityBeacon();
                    dummy.func_145834_a(world);
                    dummy.func_174878_a(entityminecart.func_180425_c());
                    dummy.func_174885_b(0, ((EntityBeaconCart)entityminecart).getLevels());
                    for (EntityPlayerMP entityplayermp : world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(i, j, k, i, j - 4.0, k).func_72314_b(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.field_192131_k.func_192180_a(entityplayermp, dummy);
                    }
                }
            }
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
        }
    };
    private IMinecartFactory factory;

    public int getBeaconLevels(ItemStack stack) {
        int sz = this.getNumBlocks(stack);
        int levels = -1;
        int len = 0;
        while ((len += (2 * ++levels + 3) * (2 * levels + 3)) <= sz) {
        }
        return levels;
    }

    public int getNumBlocks(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_150295_c("BeaconMaterials", 10).func_74745_c() : 0;
    }

    public int getNumBlocksFromLevel(int level) {
        int len = 0;
        for (int i = 0; i < level; ++i) {
            len += (2 * i + 3) * (2 * i + 3);
        }
        return len;
    }

    public List<ItemStack> getBeaconMaterials(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(stack.func_77978_p().func_150295_c("BeaconMaterials", 10).spliterator(), false).map(nbt -> (NBTTagCompound)nbt).map(ItemStack::new).collect(Collectors.toList());
    }

    public int getIronChestType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("IronChestType");
    }

    public String getIronChestTypeString(ItemStack stack) {
        return IronChestType.values()[this.getIronChestType(stack)].name();
    }

    public EnumDyeColor getBannerBaseColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return EnumDyeColor.BLACK;
        }
        return EnumDyeColor.func_176766_a((int)stack.func_77978_p().func_74762_e("Base"));
    }

    public NBTTagCompound[] getPatterns(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new NBTTagCompound[0];
        }
        return (NBTTagCompound[])Iterables.toArray((Iterable)stack.func_77978_p().func_150295_c("Patterns", 10), NBTTagCompound.class);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77960_j() == Type.BEACON.ordinal()) {
            int levels = this.getBeaconLevels(stack);
            int numBlocks = this.getNumBlocks(stack);
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.beacon_cart_num_blocks.name", (Object[])new Object[]{numBlocks}));
            tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.beacon_cart_level.name", (Object[])new Object[]{levels}));
            if (levels < 4) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.beacon_cart_blocks_until.name", (Object[])new Object[]{this.getNumBlocksFromLevel(levels + 1) - numBlocks}));
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.beacon_cart_instructions.name", (Object[])new Object[0]));
            }
        } else if (stack.func_77960_j() == Type.BANNER.ordinal()) {
            ItemStack temp = stack.func_77946_l();
            NBTTagCompound subCompound = new NBTTagCompound();
            if (temp.func_77942_o() && temp.func_77978_p().func_150297_b("Patterns", 9)) {
                subCompound.func_74782_a("Patterns", temp.func_77978_p().func_74781_a("Patterns"));
                temp.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)subCompound);
            }
            ItemBanner.func_185054_a((ItemStack)temp, tooltip);
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.banner_cart_instructions.name", (Object[])new Object[0]));
            tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.banner_cart_rotate.name", (Object[])new Object[0]));
        }
    }

    public ItemModMinecart() {
        this((worldIn, x, y, z, stack) -> Type.values()[stack.func_77960_j()].factory.create(worldIn, x, y, z, stack));
    }

    public ItemModMinecart(IMinecartFactory factory) {
        super(null);
        this.factory = factory;
        this.func_77627_a(true);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)MINECART_DISPENSER_BEHAVIOR);
        this.func_77655_b("mod_minecart").setRegistryName("mod_minecart");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Type type : Type.values()) {
                NBTTagCompound compound;
                ItemStack stack;
                if (!type.config.getAsBoolean()) continue;
                if (type == Type.BEACON) {
                    stack = new ItemStack((Item)this, 1, type.ordinal());
                    int numBlocks = 0;
                    for (int lev = 0; lev <= 4; ++lev) {
                        NBTTagCompound compound2 = new NBTTagCompound();
                        compound2.func_74782_a("BeaconMaterials", (NBTBase)Collections.nCopies(numBlocks, Blocks.field_150339_S).stream().map(ItemStack::new).map(ItemStack::serializeNBT).collect(NBTTagList::new, NBTTagList::func_74742_a, (list0, list1) -> list1.forEach(arg_0 -> ((NBTTagList)list0).func_74742_a(arg_0))));
                        stack.func_77982_d(compound2);
                        subItems.add((Object)stack.func_77946_l());
                        numBlocks += (2 * lev + 3) * (2 * lev + 3);
                    }
                    continue;
                }
                if (type == Type.IRON_CHEST) {
                    stack = new ItemStack((Item)this, 1, type.ordinal());
                    for (int ictype : IronChestStuff.getIronChestTypes()) {
                        compound = new NBTTagCompound();
                        compound.func_74768_a("IronChestType", ictype);
                        stack.func_77982_d(compound);
                        subItems.add((Object)stack.func_77946_l());
                    }
                    continue;
                }
                if (type == Type.BANNER) {
                    stack = new ItemStack((Item)this, 1, type.ordinal());
                    for (EnumDyeColor color : EnumDyeColor.values()) {
                        compound = new NBTTagCompound();
                        compound.func_74768_a("Base", color.func_176767_b());
                        stack.func_77982_d(compound);
                        subItems.add((Object)stack.func_77946_l());
                    }
                    continue;
                }
                subItems.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == Type.IRON_CHEST.ordinal()) {
            return super.func_77667_c(stack) + ".iron_chest_" + this.getIronChestTypeString(stack).toLowerCase(Locale.US);
        }
        if (stack.func_77960_j() == Type.BANNER.ordinal()) {
            return super.func_77667_c(stack) + ".banner_" + this.getBannerBaseColor(stack).func_176610_l();
        }
        return super.func_77667_c(stack) + "." + Type.values()[stack.func_77960_j()].toString().toLowerCase(Locale.US);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (!BlockRailBase.func_176563_d((IBlockState)iblockstate)) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = iblockstate.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.func_177230_c()).getRailDirection((IBlockAccess)worldIn, pos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            double d0 = 0.0;
            if (blockrailbase$enumraildirection.func_177018_c()) {
                d0 = 0.5;
            }
            EntityMinecart entityminecart = this.factory.create(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.0625 + d0, (double)pos.func_177952_p() + 0.5, itemstack);
            if (itemstack.func_82837_s()) {
                entityminecart.func_96094_a(itemstack.func_82833_r());
            }
            worldIn.func_72838_d((Entity)entityminecart);
            if (entityminecart instanceof EntityBeaconCart) {
                double i = entityminecart.field_70165_t;
                double j = entityminecart.field_70163_u;
                double k = entityminecart.field_70161_v;
                if (!worldIn.field_72995_K && 0 < ((EntityBeaconCart)entityminecart).getLevels()) {
                    TileEntityBeacon dummy = new TileEntityBeacon();
                    dummy.func_145834_a(worldIn);
                    dummy.func_174878_a(entityminecart.func_180425_c());
                    dummy.func_174885_b(0, ((EntityBeaconCart)entityminecart).getLevels());
                    for (EntityPlayerMP entityplayermp : worldIn.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(i, j, k, i, j - 4.0, k).func_72314_b(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.field_192131_k.func_192180_a(entityplayermp, dummy);
                    }
                }
            }
        }
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    @FunctionalInterface
    public static interface IMinecartFactory {
        public EntityMinecart create(World var1, double var2, double var4, double var6, ItemStack var8);
    }

    @FunctionalInterface
    public static interface IReducedMinecartFactory
    extends IMinecartFactory {
        @Override
        default public EntityMinecart create(World worldIn, double x, double y, double z, ItemStack stack) {
            return this.create(worldIn, x, y, z);
        }

        public EntityMinecart create(World var1, double var2, double var4, double var6);
    }

    public static enum Type {
        ENDER_CHEST(EntityEnderChestCart::new, () -> Config.ender_chest_cart),
        JUKEBOX(EntityJukeboxCart::new, () -> Config.jukebox_cart),
        BEACON((worldIn, x, y, z, stack) -> new EntityBeaconCart(worldIn, x, y, z).setBeaconMaterials(ModItems.mod_minecart.getBeaconMaterials(stack)), () -> Config.beacon_cart),
        IRON_CHEST((worldIn, x, y, z, stack) -> new EntityIronChestCart(worldIn, x, y, z).setChestType(ModItems.mod_minecart.getIronChestType(stack)), () -> Config.iron_chest_cart),
        NETHER_CHEST(new EntityNetherChestCart.Factory(), () -> Config.nether_chest_cart),
        BANNER((worldIn, x, y, z, stack) -> new EntityBannerCart(worldIn, x, y, z).setBaseColor(ModItems.mod_minecart.getBannerBaseColor(stack)).setPatterns(ModItems.mod_minecart.getPatterns(stack)), () -> Config.banner_cart);

        public final IMinecartFactory factory;
        public final BooleanSupplier config;

        private Type(IMinecartFactory factory, BooleanSupplier config) {
            this.factory = factory;
            this.config = config;
        }
    }
}

