/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import landmaster.cartblanche.item.ItemModMinecart;
import landmaster.cartblanche.item.ModItems;
import landmaster.cartblanche.util.BeaconCartLevelRecipe;
import landmaster.cartblanche.util.FakeOneBlockAccess;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BeaconCartLevelRecipeJEI
implements ICraftingRecipeWrapper {
    private static List<ItemStack> validStacks = null;
    private BeaconCartLevelRecipe recipe;

    public BeaconCartLevelRecipeJEI(BeaconCartLevelRecipe recipe) {
        this.recipe = recipe;
    }

    private static List<ItemStack> getValidStacks() {
        if (validStacks == null) {
            validStacks = ForgeRegistries.BLOCKS.getValuesCollection().stream().flatMap(block -> {
                NonNullList lst = NonNullList.func_191196_a();
                block.func_149666_a(CreativeTabs.field_78027_g, lst);
                return lst.stream();
            }).filter(stack -> stack.func_77973_b() instanceof ItemBlock).filter(stack -> {
                try {
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    IBlockState state = block.func_176203_a(stack.func_77960_j());
                    return block.isBeaconBase((IBlockAccess)new FakeOneBlockAccess(state), BlockPos.field_177992_a, BlockPos.field_177992_a);
                }
                catch (Throwable e) {
                    return false;
                }
            }).collect(Collectors.toList());
        }
        return validStacks;
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack beaconCart = new ItemStack((Item)ModItems.mod_minecart, 1, ItemModMinecart.Type.BEACON.ordinal());
        ArrayList<List<ItemStack>> lst = new ArrayList<List<ItemStack>>();
        lst.add(Arrays.asList(beaconCart.func_77946_l()));
        lst.addAll(Collections.nCopies(this.recipe.getNumber(), BeaconCartLevelRecipeJEI.getValidStacks()));
        ingredients.setInputLists(VanillaTypes.ITEM, lst);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("BeaconMaterials", (NBTBase)Collections.nCopies(this.recipe.getNumber(), Blocks.field_150339_S).stream().map(ItemStack::new).map(ItemStack::serializeNBT).collect(NBTTagList::new, NBTTagList::func_74742_a, (list0, list1) -> list1.forEach(arg_0 -> ((NBTTagList)list0).func_74742_a(arg_0))));
        beaconCart.func_77982_d(compound);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)beaconCart.func_77946_l());
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }
}

