/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.proxy;

import java.util.function.Function;
import landmaster.cartblanche.config.Config;
import landmaster.cartblanche.entity.EntityBannerCart;
import landmaster.cartblanche.entity.EntityBeaconCart;
import landmaster.cartblanche.entity.EntityEnderChestCart;
import landmaster.cartblanche.entity.EntityIronChestCart;
import landmaster.cartblanche.entity.EntityJukeboxCart;
import landmaster.cartblanche.entity.EntityNetherChestCart;
import landmaster.cartblanche.entity.render.RenderBannerCart;
import landmaster.cartblanche.entity.render.RenderBeaconCart;
import landmaster.cartblanche.entity.render.RenderIronChestCart;
import landmaster.cartblanche.entity.render.RenderNetherChestCart;
import landmaster.cartblanche.item.ItemModMinecart;
import landmaster.cartblanche.item.ModItems;
import landmaster.cartblanche.proxy.CommonProxy;
import landmaster.cartblanche.sound.JukeboxCartSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void initEntityRendering() {
        if (Config.ender_chest_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityEnderChestCart.class, RenderMinecart::new);
        }
        if (Config.jukebox_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityJukeboxCart.class, RenderMinecart::new);
        }
        if (Config.beacon_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBeaconCart.class, RenderBeaconCart::new);
        }
        if (Config.iron_chest_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityIronChestCart.class, RenderIronChestCart::new);
        }
        if (Config.nether_chest_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityNetherChestCart.class, RenderNetherChestCart::new);
        }
        if (Config.banner_cart) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBannerCart.class, RenderBannerCart::new);
        }
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("cartblanche:" + id, "inventory"));
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id, String variant) {
        ModelResourceLocation rl = new ModelResourceLocation("cartblanche:" + id, variant);
        if (meta >= 0) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)rl);
        } else {
            ModelLoader.setCustomMeshDefinition((Item)item, stack -> rl);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{rl});
        }
    }

    @Override
    public void registerItemRenderer(Item item, Function<ItemStack, ModelResourceLocation> mapper, ResourceLocation ... locs) {
        ModelLoader.setCustomMeshDefinition((Item)item, mapper::apply);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])locs);
    }

    @Override
    public Object playJukeboxCartSound(SoundEvent soundIn, SoundCategory categoryIn, EntityJukeboxCart cart) {
        JukeboxCartSound sound = new JukeboxCartSound(soundIn, categoryIn, cart);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        return sound;
    }

    @Override
    public boolean isSoundPlaying(Object sound) {
        if (sound instanceof ISound) {
            return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound);
        }
        return false;
    }

    @Override
    public void stopSound(Object sound) {
        if (sound instanceof ISound) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
        }
    }

    @Override
    public void registerColors() {
        if (Config.banner_cart) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((stack, idx) -> {
                if (stack.func_77960_j() == ItemModMinecart.Type.BANNER.ordinal() && idx == 1) {
                    return ModItems.mod_minecart.getBannerBaseColor(stack).func_193350_e();
                }
                return 0xFFFFFF;
            }, new Item[]{ModItems.mod_minecart});
        }
    }
}

