/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.util;

import java.util.ArrayList;
import landmaster.cartblanche.item.ItemModMinecart;
import landmaster.cartblanche.item.ModItems;
import landmaster.cartblanche.util.FakeOneBlockAccess;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BeaconCartLevelRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private int number;

    public BeaconCartLevelRecipe(int number) {
        this.number = number;
        this.setRegistryName("beacon_cart_level_" + number);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    private static IBlockState blockFromStack(ItemStack stack) {
        try {
            return Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack beaconCart = ItemStack.field_190927_a;
        ArrayList<ItemStack> blocks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)new ItemStack((Item)ModItems.mod_minecart, 1, ItemModMinecart.Type.BEACON.ordinal()))) {
                if (!beaconCart.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                beaconCart = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()).isBeaconBase((IBlockAccess)new FakeOneBlockAccess(BeaconCartLevelRecipe.blockFromStack(stack)), BlockPos.field_177992_a, BlockPos.field_177992_a)) {
                ItemStack oneItemStack = stack.func_77946_l();
                oneItemStack.func_190920_e(1);
                blocks.add(oneItemStack);
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (beaconCart.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int curBlocks = ModItems.mod_minecart.getNumBlocks(beaconCart);
        if (blocks.size() == this.number && curBlocks + blocks.size() <= 164) {
            ItemStack res = beaconCart.func_77946_l();
            if (!res.func_77942_o()) {
                res.func_77982_d(new NBTTagCompound());
            }
            NBTTagList list = res.func_77978_p().func_150295_c("BeaconMaterials", 10);
            blocks.stream().map(ItemStack::serializeNBT).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
            return res;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.number + 1;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

