/*
 * Decompiled with CFR 0.152.
 */
package landmaster.cartblanche.util;

import com.google.common.base.Throwables;
import cpw.mods.ironchest.client.gui.chest.GUIChest;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.items.chest.ItemChestChanger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import landmaster.cartblanche.entity.EntityIronChestCart;
import landmaster.cartblanche.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class IronChestStuff {
    private static final MethodHandle guiChestConstructorHandle;

    @SubscribeEvent
    public static void onEntityInteract(MinecartInteractEvent event) {
        if (event.getMinecart().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getItem().func_77973_b() instanceof ItemChestChanger) {
            EntityIronChestCart cart;
            boolean worked = false;
            ItemChestChanger changer = (ItemChestChanger)event.getItem().func_77973_b();
            if (changer.type.canUpgrade(IronChestType.WOOD) && event.getMinecart() instanceof EntityMinecartChest) {
                final EntityMinecartChest oldCart = (EntityMinecartChest)event.getMinecart();
                oldCart.func_184174_b(false);
                final EntityIronChestCart newCart = new EntityIronChestCart(oldCart.field_70170_p);
                NBTTagCompound compound = new NBTTagCompound();
                oldCart.func_189511_e(compound);
                compound.func_74768_a("IronChestType", changer.type.target.ordinal());
                newCart.func_70020_e(compound);
                oldCart.field_70170_p.func_72900_e((Entity)oldCart);
                MinecraftForge.EVENT_BUS.register(new Object(){

                    @SubscribeEvent
                    public void onServerTick(TickEvent.ServerTickEvent event0) {
                        if (oldCart.field_70170_p instanceof WorldServer && ((WorldServer)oldCart.field_70170_p).func_175733_a(oldCart.func_110124_au()) == null) {
                            oldCart.field_70170_p.func_72838_d((Entity)newCart);
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    }
                });
                worked = true;
            } else if (event.getMinecart() instanceof EntityIronChestCart && changer.type.canUpgrade((cart = (EntityIronChestCart)event.getMinecart()).getChestType())) {
                cart.setChestType(changer.type.target);
                worked = true;
            }
            if (worked) {
                if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                    event.getItem().func_190918_g(1);
                }
                event.setCanceled(true);
            }
        }
    }

    public static Container getChestContainerForMinecart(EntityPlayer player, World world, int entityID) {
        Entity entity = world.func_73045_a(entityID);
        if (entity instanceof EntityIronChestCart) {
            EntityIronChestCart ironChestCart = (EntityIronChestCart)entity;
            return ironChestCart.func_174876_a(player.field_71071_by, player);
        }
        return null;
    }

    public static Object getChestGuiForMinecart(EntityPlayer player, World world, int entityID) {
        Entity entity = world.func_73045_a(entityID);
        if (entity instanceof EntityIronChestCart) {
            EntityIronChestCart ironChestCart = (EntityIronChestCart)entity;
            try {
                return guiChestConstructorHandle.invokeExact(GUIChest.GUI.values()[ironChestCart.getChestType().ordinal()], (IInventory)player.field_71071_by, (IInventory)ironChestCart);
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static int[] getIronChestTypes() {
        return Arrays.stream(IronChestType.VALUES).filter(IronChestType::isValidForCreativeMode).mapToInt(Enum::ordinal).toArray();
    }

    public static String ironChestStringFromInt(int val) {
        return IronChestType.VALUES[val].name();
    }

    static {
        MinecraftForge.EVENT_BUS.register(IronChestStuff.class);
        try {
            guiChestConstructorHandle = FMLCommonHandler.instance().getSide() == Side.CLIENT ? Utils.IMPL_LOOKUP.findConstructor(GUIChest.class, MethodType.methodType(Void.TYPE, GUIChest.GUI.class, IInventory.class, IInventory.class)) : null;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

