/*
 * Decompiled with CFR 0.152.
 */
package landlust.blocks;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import landlust.Landlust;
import landlust.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockBed
extends Block {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumPartType> PROPERTYPART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyBool PROPERTYOCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.7, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.7, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.7, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.7, 1.0);

    public BlockBed() {
        super(Material.field_151575_d);
        this.func_149663_c("landlust.bed");
        this.setRegistryName("bed");
        this.func_149711_c(1.0f);
        this.func_149647_a(Landlust.landlustTab);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return NORTH_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b(PROPERTYPART) == EnumPartType.FOOT) {
            return EnumBlockRenderType.INVISIBLE;
        }
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.func_176731_b((int)meta)) : this.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176736_b();
        return state.func_177229_b(PROPERTYPART) == EnumPartType.HEAD ? (i = i | 8) : i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING, PROPERTYPART, PROPERTYOCCUPIED});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing blockFacing = placer.func_174811_aO().func_176734_d();
        world.func_175656_a(pos.func_177967_a(blockFacing, 1), ModBlocks.bed.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing.func_176734_d()));
        return this.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        worldIn.func_175655_b(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)), false);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177229_b(PROPERTYPART) != EnumPartType.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176734_d()))).func_177230_c() != this) {
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && worldIn.func_180494_b(pos) != Biomes.field_76778_j) {
            EntityPlayer entityplayer = this.getPlayerInBed(worldIn, pos);
            if (entityplayer != null) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                return true;
            }
            EntityPlayer.SleepResult entityplayer$sleepresult = playerIn.func_180469_a(pos);
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.OK) {
                return true;
            }
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        worldIn.func_72885_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    @Nullable
    public static BlockPos getSafeExitLocation(World worldIn, BlockPos pos, int tries) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)PROPERTYFACING);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockBed.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

