/*
 * Decompiled with CFR 0.152.
 */
package landlust.blocks;

import java.util.Random;
import landlust.Landlust;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCandle
extends Block {
    public static final PropertyInteger PROPERTYFACING = PropertyInteger.func_177719_a((String)"facing", (int)0, (int)4);
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.6, 0.6);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.4, 0.0, 0.6, 0.6, 0.6, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.4, 0.0, 0.0, 0.6, 0.6, 0.4);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.6, 0.0, 0.4, 1.0, 0.6, 0.6);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.4, 0.4, 0.6, 0.6);

    public BlockCandle() {
        super(Material.field_151594_q);
        this.func_149663_c("landlust.candle");
        this.setRegistryName("candle");
        this.func_149647_a(Landlust.landlustTab);
        this.func_149715_a(1.0f);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)PROPERTYFACING)) {
            case 0: {
                return STANDING_AABB;
            }
            case 1: {
                return NORTH_AABB;
            }
            case 2: {
                return SOUTH_AABB;
            }
            case 3: {
                return WEST_AABB;
            }
            case 4: {
                return EAST_AABB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PROPERTYFACING);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int direction = 0;
        if (facing.equals((Object)EnumFacing.UP)) {
            direction = 0;
        }
        if (facing.equals((Object)EnumFacing.NORTH)) {
            direction = 1;
        }
        if (facing.equals((Object)EnumFacing.SOUTH)) {
            direction = 2;
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            direction = 3;
        }
        if (facing.equals((Object)EnumFacing.EAST)) {
            direction = 4;
        }
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)Integer.valueOf(direction));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int direction = (Integer)stateIn.func_177229_b((IProperty)PROPERTYFACING);
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        switch (direction) {
            case 0: {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.5, y + 0.75, z + 0.5, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 1: {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.5, y + 0.75, z + 0.75, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 2: {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.5, y + 0.75, z + 0.25, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 3: {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.75, y + 0.75, z + 0.5, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 4: {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.25, y + 0.75, z + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

