/*
 * Decompiled with CFR 0.152.
 */
package landlust.blocks;

import com.google.common.base.Predicate;
import landlust.Landlust;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFancyChair
extends Block {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum PROPERTYCOLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);

    public BlockFancyChair() {
        super(Material.field_151575_d);
        this.func_149663_c("landlust.chair_fancy");
        this.setRegistryName("chair_fancy");
        this.func_149711_c(1.0f);
        this.func_149647_a(Landlust.landlustTab);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        EnumColor enumColour = (EnumColor)((Object)state.func_177229_b((IProperty)PROPERTYCOLOR));
        return enumColour.getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        int colorbits = (meta & 0xC) >> 2;
        EnumColor color = EnumColor.byMetadata(colorbits);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)color)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        EnumColor color = (EnumColor)((Object)state.func_177229_b((IProperty)PROPERTYCOLOR));
        int facingbits = facing.func_176736_b();
        int colorbits = color.getMetadata() << 2;
        return facingbits | colorbits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYCOLOR, PROPERTYFACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumColor color = EnumColor.byMetadata(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)color));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        EnumColor[] allColors;
        for (EnumColor color : allColors = EnumColor.values()) {
            list.add((Object)new ItemStack((Block)this, 1, color.getMetadata()));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemDye) {
            switch (heldItem.func_77952_i()) {
                case 1: {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)EnumColor.RED)));
                    heldItem.func_190918_g(1);
                    return true;
                }
                case 2: {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)EnumColor.GREEN)));
                    heldItem.func_190918_g(1);
                    return true;
                }
                case 4: {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)EnumColor.BLUE)));
                    heldItem.func_190918_g(1);
                    return true;
                }
                case 15: {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTYCOLOR, (Comparable)((Object)EnumColor.WHITE)));
                    heldItem.func_190918_g(1);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static enum EnumColor implements IStringSerializable
    {
        WHITE(0, "white"),
        BLUE(1, "blue"),
        GREEN(2, "green"),
        RED(3, "red");

        private final int meta;
        private final String name;
        private static final EnumColor[] META_LOOKUP;

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumColor byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        private EnumColor(int i_meta, String i_name) {
            this.meta = i_meta;
            this.name = i_name;
        }

        static {
            META_LOOKUP = new EnumColor[EnumColor.values().length];
            EnumColor[] enumColorArray = EnumColor.values();
            int n = enumColorArray.length;
            for (int i = 0; i < n; ++i) {
                EnumColor color;
                EnumColor.META_LOOKUP[color.getMetadata()] = color = enumColorArray[i];
            }
        }
    }
}

