/*
 * Decompiled with CFR 0.152.
 */
package landlust.blocks;

import com.google.common.base.Predicate;
import landlust.Landlust;
import landlust.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockWardrobe
extends Block {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumPartType> PROPERTYPART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.2, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.8);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.2, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.0, 1.0);

    public BlockWardrobe() {
        super(Material.field_151575_d);
        this.func_149663_c("landlust.wardrobe");
        this.setRegistryName("wardrobe");
        this.func_149711_c(1.0f);
        this.func_149647_a(Landlust.landlustTab);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return NORTH_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b(PROPERTYPART) != EnumPartType.LEFTLOW) {
            return EnumBlockRenderType.INVISIBLE;
        }
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        int partbits = (meta & 0xC) >> 2;
        EnumPartType color = EnumPartType.byMetadata(partbits);
        return this.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)color)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        EnumPartType part = (EnumPartType)((Object)state.func_177229_b(PROPERTYPART));
        int facingbits = facing.func_176736_b();
        int partbits = part.getMetadata() << 2;
        return facingbits | partbits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING, PROPERTYPART});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing blockFacing = placer.func_174811_aO().func_176734_d();
        world.func_175656_a(pos.func_177967_a(blockFacing.func_176735_f(), 1), ModBlocks.wardrobe.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.RIGHTLOW)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing));
        world.func_175656_a(pos.func_177984_a(), ModBlocks.wardrobe.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.LEFTUP)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing));
        world.func_175656_a(pos.func_177967_a(blockFacing.func_176735_f(), 1).func_177984_a(), ModBlocks.wardrobe.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.RIGHTUP)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing));
        return this.func_176223_P().func_177226_a(PROPERTYPART, (Comparable)((Object)EnumPartType.LEFTLOW)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)blockFacing);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        switch ((EnumPartType)((Object)state.func_177229_b(PROPERTYPART))) {
            case LEFTLOW: {
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176735_f()));
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176735_f()).func_177984_a());
                worldIn.func_175698_g(pos.func_177984_a());
                return;
            }
            case LEFTUP: {
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176735_f()));
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176735_f()).func_177977_b());
                worldIn.func_175698_g(pos.func_177977_b());
                return;
            }
            case RIGHTLOW: {
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176746_e()));
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176746_e()).func_177984_a());
                worldIn.func_175698_g(pos.func_177984_a());
                return;
            }
            case RIGHTUP: {
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176746_e()));
                worldIn.func_175698_g(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176746_e()).func_177977_b());
                worldIn.func_175698_g(pos.func_177977_b());
                return;
            }
        }
    }

    public static enum EnumPartType implements IStringSerializable
    {
        LEFTLOW(0, "leftlow"),
        LEFTUP(1, "leftup"),
        RIGHTLOW(2, "rightlow"),
        RIGHTUP(3, "rightup");

        private final int meta;
        private final String name;
        private static final EnumPartType[] META_LOOKUP;

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumPartType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        private EnumPartType(int i_meta, String i_name) {
            this.meta = i_meta;
            this.name = i_name;
        }

        static {
            META_LOOKUP = new EnumPartType[EnumPartType.values().length];
            EnumPartType[] enumPartTypeArray = EnumPartType.values();
            int n = enumPartTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPartType part;
                EnumPartType.META_LOOKUP[part.getMetadata()] = part = enumPartTypeArray[i];
            }
        }
    }
}

