/*
 * Decompiled with CFR 0.152.
 */
package landlust.items;

import java.util.LinkedList;
import java.util.List;
import landlust.blocks.BlockCouch;
import landlust.blocks.BlockWhingChair;
import landlust.blocks.ModBlocks;
import landlust.items.ItemCouchVariants;
import landlust.items.ItemFancyChairVariants;
import landlust.items.ItemFootrestVariants;
import landlust.items.ItemWhingChairVariants;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static ItemCouchVariants itemCouchVariants;
    public static ItemFancyChairVariants itemFancyChairVariants;
    public static ItemFootrestVariants itemFootrestVariants;
    public static ItemWhingChairVariants itemWhingChairVariants;

    public static void init() {
        itemCouchVariants = new ItemCouchVariants(ModBlocks.couch);
        itemFancyChairVariants = new ItemFancyChairVariants(ModBlocks.fancyChair);
        itemFootrestVariants = new ItemFootrestVariants(ModBlocks.footrest);
        itemWhingChairVariants = new ItemWhingChairVariants(ModBlocks.whingChair);
    }

    public static void initClient() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders(Item item) {
        if (!item.func_77614_k()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        } else {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(null, list);
            for (ItemStack stack : list) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + BlockCouch.EnumColor.byMetadata(stack.func_77952_i()).toString(), "inventory"));
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ItemRegistry {
        public static final List<Item> ITEMS = new LinkedList<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
            event.getRegistry().register((IForgeRegistryEntry)itemCouchVariants);
            event.getRegistry().register((IForgeRegistryEntry)itemFancyChairVariants);
            event.getRegistry().register((IForgeRegistryEntry)itemFootrestVariants);
            event.getRegistry().register((IForgeRegistryEntry)itemWhingChairVariants);
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ITEMS.forEach(item -> ModItems.registerRenders(item));
            ModelLoader.setCustomModelResourceLocation((Item)itemCouchVariants, (int)BlockWhingChair.EnumColor.BROWN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:couch_brown", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemCouchVariants, (int)BlockWhingChair.EnumColor.BLUE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:couch_blue", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemCouchVariants, (int)BlockWhingChair.EnumColor.GREEN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:couch_green", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemCouchVariants, (int)BlockWhingChair.EnumColor.RED.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:couch_red", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFancyChairVariants, (int)BlockWhingChair.EnumColor.BROWN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:chair_fancy_brown", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFancyChairVariants, (int)BlockWhingChair.EnumColor.BLUE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:chair_fancy_blue", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFancyChairVariants, (int)BlockWhingChair.EnumColor.GREEN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:chair_fancy_green", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFancyChairVariants, (int)BlockWhingChair.EnumColor.RED.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:chair_fancy_red", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFootrestVariants, (int)BlockWhingChair.EnumColor.BROWN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:footrest_brown", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFootrestVariants, (int)BlockWhingChair.EnumColor.BLUE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:footrest_blue", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFootrestVariants, (int)BlockWhingChair.EnumColor.GREEN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:footrest_green", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFootrestVariants, (int)BlockWhingChair.EnumColor.RED.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:footrest_red", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemWhingChairVariants, (int)BlockWhingChair.EnumColor.BROWN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:whing_chair_brown", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemWhingChairVariants, (int)BlockWhingChair.EnumColor.BLUE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:whing_chair_blue", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemWhingChairVariants, (int)BlockWhingChair.EnumColor.GREEN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:whing_chair_green", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemWhingChairVariants, (int)BlockWhingChair.EnumColor.RED.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("landlust:whing_chair_red", "inventory"));
        }
    }
}

