/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.api.ITurretBaseAddonBlock;
import omtteam.openmodularturrets.blocks.BlockTurretBase;
import omtteam.openmodularturrets.tileentity.TurretBase;

public abstract class BlockTurretBaseAttachment
extends BlockAbstractTileEntity
implements ITurretBaseAddonBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockTurretBaseAttachment(Material material) {
        super(material);
    }

    public static AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing) {
        AxisAlignedBB alignedBB = MathUtil.rotateAABB((AxisAlignedBB)new AxisAlignedBB(-0.375, -0.375, -0.1875, 0.375, 0.375, 0.1875), (EnumFacing)facing.func_176734_d());
        double[] offset = new double[]{0.5 + (double)facing.func_82601_c() * 0.325, 0.5 + (double)facing.func_96559_d() * 0.325, 0.5 + (double)facing.func_82599_e() * 0.325};
        return alignedBB.func_72317_d(offset[0], offset[1], offset[2]);
    }

    @Override
    public AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing, World world, BlockPos pos) {
        return BlockTurretBaseAttachment.getBoundingBoxFromFacing(facing).func_186670_a(pos);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState blockState = this.func_176221_a(state, source, pos);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return BlockTurretBaseAttachment.getBoundingBoxFromFacing(facing);
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)worldIn, (BlockPos)pos)) {
            if (!(tileEntity instanceof TurretBase)) continue;
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean found = false;
        for (IBlockState blockState : WorldUtil.getTouchingBlockStates((World)worldIn, (BlockPos)pos)) {
            if (!(blockState.func_177230_c() instanceof BlockTurretBase)) continue;
            found = true;
        }
        if (!found) {
            worldIn.func_175655_b(pos, true);
        }
    }
}

