/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import omtteam.omlib.api.block.IHasItemBlock;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.util.MathUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.api.ITurretBaseAddonBlock;
import omtteam.openmodularturrets.items.blocks.ItemBlockLever;
import omtteam.openmodularturrets.tileentity.LeverTileEntity;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class LeverBlock
extends BlockAbstractTileEntity
implements IHasItemBlock,
ITurretBaseAddonBlock {
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)4);

    public LeverBlock() {
        super(Material.field_151592_s);
        this.func_149663_c("lever_block");
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("openmodularturrets", "lever_block");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockLever(block);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World worldIn, IBlockState blockState) {
        return new LeverTileEntity();
    }

    private boolean isBaseValid(TileEntity base) {
        return base instanceof TurretBase && ((TurretBase)base).getTier() == 1;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.isBaseValid(worldIn.func_175625_s(pos.func_177978_c())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177974_f())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177968_d())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177976_e()));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        float l = 0.0f;
        if (this.isBaseValid(worldIn.func_175625_s(pos.func_177974_f()))) {
            l = 270.0f;
        }
        if (this.isBaseValid(worldIn.func_175625_s(pos.func_177976_e()))) {
            l = 90.0f;
        }
        if (this.isBaseValid(worldIn.func_175625_s(pos.func_177968_d()))) {
            l = 0.0f;
        }
        if (this.isBaseValid(worldIn.func_175625_s(pos.func_177978_c()))) {
            l = 180.0f;
        }
        int shu = MathHelper.func_76128_c((double)((double)(l * 4.0f / 360.0f) + 0.5)) & 3;
        worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(shu)), 3);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (TurretHeadUtil.getTurretBaseFacing(worldIn, pos) == EnumFacing.DOWN || TurretHeadUtil.getTurretBaseFacing(worldIn, pos) == EnumFacing.UP) {
            return true;
        }
        TurretBase base = TurretHeadUtil.getTurretBase(worldIn, pos);
        LeverTileEntity lever = (LeverTileEntity)worldIn.func_175625_s(pos);
        OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (storage == null) {
            return true;
        }
        if (lever != null && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROTATION) * 90 == 0 && this.isBaseValid(worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1))) && (base = (TurretBase)worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1))) != null) {
            lever.isTurning = true;
            if (lever.rotation == 0.0f) {
                storage.receiveEnergy(50, false);
            }
        }
        if (lever != null && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROTATION) * 90 == 90 && this.isBaseValid(worldIn.func_175625_s(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) && (base = (TurretBase)worldIn.func_175625_s(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) != null) {
            lever.isTurning = true;
            if (lever.rotation == 0.0f) {
                storage.receiveEnergy(50, false);
            }
        }
        if (lever != null && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROTATION) * 90 == 180 && this.isBaseValid(worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1))) && (base = (TurretBase)worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1))) != null) {
            lever.isTurning = true;
            if (lever.rotation == 0.0f) {
                storage.receiveEnergy(50, false);
            }
        }
        if (lever != null && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROTATION) * 90 == 270 && this.isBaseValid(worldIn.func_175625_s(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()))) && (base = (TurretBase)worldIn.func_175625_s(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()))) != null) {
            lever.isTurning = true;
            if (lever.rotation == 0.0f) {
                storage.receiveEnergy(50, false);
            }
        }
        return true;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, (double)0.9f, (double)0.9f);
    }

    @Override
    public AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing, World world, BlockPos pos) {
        facing = TurretHeadUtil.getTurretBaseFacing(world, pos);
        if (TurretHeadUtil.getTurretBase(world, pos) != null && TurretHeadUtil.getTurretBase(world, pos).getTier() == 1 && facing != null) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)-0.3f, (double)-0.3f, (double)-0.4f, (double)0.3f, (double)0.3f, (double)0.4f);
            axisAlignedBB = MathUtil.rotateAABB((AxisAlignedBB)axisAlignedBB, (EnumFacing)facing.func_176734_d());
            double[] offset = new double[]{0.5 + (double)facing.func_82601_c() * 0.1, 0.5 + (double)facing.func_96559_d() * 0.1, 0.5 + (double)facing.func_82599_e() * 0.1};
            return axisAlignedBB.func_186670_a(pos).func_72317_d(offset[0], offset[1], offset[2]);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186670_a(pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos neighbor) {
        if (!(this.isBaseValid(worldIn.func_175625_s(pos.func_177978_c())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177974_f())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177968_d())) || this.isBaseValid(worldIn.func_175625_s(pos.func_177976_e())))) {
            worldIn.func_175655_b(pos, true);
        }
    }
}

