/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.kubejs;

import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageSyncEditingMode;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.task.Task;
import dev.latvian.kubejs.documentation.DisplayName;
import dev.latvian.kubejs.documentation.Info;
import dev.latvian.kubejs.documentation.P;
import dev.latvian.kubejs.player.PlayerDataJS;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

@DisplayName(value="FTB Quests Player Data")
public class FTBQuestsKubeJSPlayerData {
    private final PlayerDataJS playerData;

    public FTBQuestsKubeJSPlayerData(PlayerDataJS p) {
        this.playerData = p;
    }

    @Info(value="Returns true if player is in editing mode")
    public boolean getCanEdit() {
        EntityPlayer p = this.playerData.getPlayerEntity();
        return p != null && FTBQuests.canEdit(p);
    }

    @Info(value="Sets editing mode for player")
    public void setCanEdit(@P(value="canEdit") boolean canEdit) {
        EntityPlayer p = this.playerData.getPlayerEntity();
        if (p != null) {
            NBTUtils.getPersistedData((EntityPlayer)p, (boolean)canEdit).func_74757_a("ftbquests_editing_mode", canEdit);
            if (p instanceof EntityPlayerMP) {
                new MessageSyncEditingMode(canEdit).sendTo((EntityPlayerMP)p);
            }
        }
    }

    @Nullable
    public QuestFile getFile() {
        return FTBQuests.PROXY.getQuestFile(this.playerData.getOverworld().minecraftWorld);
    }

    @Nullable
    public QuestData getData() {
        QuestFile file = this.getFile();
        EntityPlayer player = this.playerData.getPlayerEntity();
        return file == null || player == null ? null : file.getData((Entity)player);
    }

    public void addProgress(@P(value="id") Object id, @P(value="progress") long progress) {
        QuestData data = this.getData();
        if (data == null) {
            return;
        }
        Task task = data.getFile().getTask(data.getFile().getID(id));
        if (task != null) {
            data.getTaskData(task).addProgress(progress);
        }
    }

    public void complete(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return;
        }
        QuestObject object = data.getFile().get(data.getFile().getID(id));
        if (object != null) {
            object.forceProgress(data, ChangeProgress.COMPLETE, false);
        }
    }

    public void reset(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return;
        }
        QuestObject object = data.getFile().get(data.getFile().getID(id));
        if (object != null) {
            object.forceProgress(data, ChangeProgress.RESET, false);
        }
    }

    public boolean isCompleted(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return false;
        }
        QuestObject object = data.getFile().get(data.getFile().getID(id));
        return object != null && object.isComplete(data);
    }

    public boolean isStarted(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return false;
        }
        QuestObject object = data.getFile().get(data.getFile().getID(id));
        return object != null && object.isStarted(data);
    }

    public boolean canStartQuest(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return false;
        }
        Quest quest = data.getFile().getQuest(data.getFile().getID(id));
        return quest != null && quest.canStartTasks(data);
    }

    public int getProgress(@P(value="id") Object id) {
        QuestData data = this.getData();
        if (data == null) {
            return 0;
        }
        QuestObject object = data.getFile().get(data.getFile().getID(id));
        return object != null ? object.getRelativeProgress(data) : 0;
    }
}

