/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.projecte;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.projecte.ProjectEIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EMCTask
extends Task
implements ISingleLongValueTask {
    public long value = 8192L;

    public EMCTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return ProjectEIntegration.EMC_TASK;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return String.format("%,d", this.value);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
    }

    @Override
    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 8192L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.emc", new Object[0]));
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.emc", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + this.getMaxProgressString();
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<EMCTask> {
        private Data(EMCTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return String.format("%,d", this.progress);
        }

        @Override
        public void submitTask(EntityPlayerMP player, ItemStack item) {
            if (this.isComplete()) {
                return;
            }
            IKnowledgeProvider knowledge = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(player.func_110124_au());
            double emc = knowledge.getEmc();
            double add = Math.min(emc, (double)(((EMCTask)this.task).value - this.progress));
            if (add > 0.0) {
                knowledge.setEmc(emc - add);
                knowledge.sync(player);
                this.addProgress((long)add);
            }
        }
    }
}

