/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Chapter
extends QuestObject {
    public final QuestFile file;
    public final List<Quest> quests;
    public final List<String> subtitle;
    public boolean alwaysInvisible;
    public Chapter group;
    public QuestShape defaultQuestShape;
    public final List<ChapterImage> images;

    public Chapter(QuestFile f) {
        this.file = f;
        this.quests = new ArrayList<Quest>();
        this.subtitle = new ArrayList<String>(0);
        this.alwaysInvisible = false;
        this.group = null;
        this.defaultQuestShape = QuestShape.DEFAULT;
        this.images = new ArrayList<ChapterImage>();
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        NBTTagList list;
        super.writeData(nbt);
        if (!this.subtitle.isEmpty()) {
            list = new NBTTagList();
            for (String v : this.subtitle) {
                list.func_74742_a((NBTBase)new NBTTagString(v));
            }
            nbt.func_74782_a("description", (NBTBase)list);
        }
        nbt.func_74757_a("always_invisible", this.alwaysInvisible);
        nbt.func_74768_a("group", this.group != null && !this.group.invalid ? this.group.id : 0);
        nbt.func_74778_a("default_quest_shape", this.defaultQuestShape.getId());
        if (!this.images.isEmpty()) {
            list = new NBTTagList();
            for (ChapterImage image : this.images) {
                NBTTagCompound nbt1 = new NBTTagCompound();
                image.writeData(nbt1);
                list.func_74742_a((NBTBase)nbt1);
            }
            nbt.func_74782_a("images", (NBTBase)list);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.subtitle.clear();
        NBTTagList desc = nbt.func_150295_c("description", 8);
        for (int i = 0; i < desc.func_74745_c(); ++i) {
            this.subtitle.add(desc.func_150307_f(i));
        }
        this.alwaysInvisible = nbt.func_74767_n("always_invisible");
        this.group = this.file.getChapter(nbt.func_74762_e("group"));
        this.defaultQuestShape = (QuestShape)((Object)QuestShape.NAME_MAP.get(nbt.func_74779_i("default_quest_shape")));
        NBTTagList imgs = nbt.func_150295_c("images", 10);
        this.images.clear();
        for (int i = 0; i < imgs.func_74745_c(); ++i) {
            ChapterImage image = new ChapterImage(this);
            image.readData(imgs.func_150305_b(i));
            this.images.add(image);
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.subtitle, DataOut.STRING);
        data.writeBoolean(this.alwaysInvisible);
        data.writeInt(this.group == null || this.group.invalid ? 0 : this.group.id);
        QuestShape.NAME_MAP.write(data, (Object)this.defaultQuestShape);
        data.writeCollection(this.images, (d, object) -> object.writeNetData(d));
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.subtitle, DataIn.STRING);
        this.alwaysInvisible = data.readBoolean();
        this.group = this.file.getChapter(data.readInt());
        this.defaultQuestShape = (QuestShape)((Object)QuestShape.NAME_MAP.read(data));
        data.readCollection(this.images, d -> {
            ChapterImage image = new ChapterImage(this);
            image.readNetData(d);
            return image;
        });
    }

    public int getIndex() {
        return this.file.chapters.indexOf(this);
    }

    @Override
    public int getRelativeProgressFromChildren(QuestData data) {
        if (this.alwaysInvisible) {
            return 100;
        }
        List<Chapter> children = this.getChildren();
        if (this.quests.isEmpty() && children.isEmpty()) {
            return 100;
        }
        int progress = 0;
        int count = 0;
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            progress += quest.getRelativeProgress(data);
            ++count;
        }
        for (Chapter chapter : this.getChildren()) {
            progress += chapter.getRelativeProgressFromChildren(data);
            ++count;
        }
        if (count <= 0) {
            return 100;
        }
        return Chapter.getRelativeProgressFromChildren(progress, count);
    }

    @Override
    public void onCompleted(QuestData data, List<EntityPlayerMP> onlineMembers, List<EntityPlayerMP> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        new ObjectCompletedEvent.ChapterEvent(data, this, onlineMembers, notifiedPlayers).post();
        if (!this.disableToast) {
            for (EntityPlayerMP player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        if (this.file.isComplete(data)) {
            this.file.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    @Override
    public void changeProgress(QuestData data, ChangeProgress type) {
        for (Quest quest : this.quests) {
            quest.changeProgress(data, type);
        }
        for (Chapter chapter : this.getChildren()) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        for (Chapter child : this.getChildren()) {
            list.add(child.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.unnamed", (Object[])new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        this.file.chapters.add(this);
        if (!this.quests.isEmpty()) {
            for (Quest quest : ListUtils.clearAndCopy(this.quests)) {
                quest.onCreated();
            }
        }
    }

    @Override
    public File getFile() {
        return new File(this.file.getFolder(), "chapters/" + Chapter.getCodeString(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("subtitle", this.subtitle, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addBool("always_invisible", () -> this.alwaysInvisible, v -> {
            this.alwaysInvisible = v;
        }, false);
        Predicate<QuestObjectBase> predicate = object -> object == null || object instanceof Chapter && object != this && ((Chapter)object).group == null;
        config.add("group", (ConfigValue)new ConfigQuestObject(this.file, Chapter.getID(this.group), predicate){

            @Override
            public int getObject() {
                return QuestObjectBase.getID(Chapter.this.group);
            }

            @Override
            public void setObject(int v) {
                Chapter.this.group = this.file.getChapter(v);
            }
        }, (ConfigValue)new ConfigQuestObject(this.file, 0, predicate));
        config.addEnum("default_quest_shape", () -> this.defaultQuestShape, v -> {
            this.defaultQuestShape = v;
        }, QuestShape.NAME_MAP);
    }

    @Override
    public boolean isVisible(QuestData data) {
        if (this.alwaysInvisible) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isVisible(data)) continue;
            return true;
        }
        for (Chapter child : this.getChildren()) {
            if (!child.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
        for (Chapter chapter : this.getChildren()) {
            chapter.clearCachedData();
        }
    }

    public boolean hasChildren() {
        if (this.group != null) {
            return false;
        }
        for (Chapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getChildren() {
        List<Chapter> list = Collections.emptyList();
        if (this.group != null) {
            return list;
        }
        for (Chapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Chapter>(3);
            }
            list.add(chapter);
        }
        return list;
    }

    public boolean hasUnclaimedRewards(UUID player, QuestData data, boolean showExcluded) {
        for (Quest quest : this.quests) {
            if (!quest.hasUnclaimedRewards(player, data, showExcluded)) continue;
            return true;
        }
        for (Chapter chapter : this.getChildren()) {
            if (!chapter.hasUnclaimedRewards(player, data, showExcluded)) continue;
            return true;
        }
        return false;
    }

    public int getUnclaimedRewards(UUID player, QuestData data, boolean showExcluded) {
        int r = 0;
        for (Quest quest : this.quests) {
            r += quest.getUnclaimedRewards(player, data, showExcluded);
        }
        for (Chapter chapter : this.getChildren()) {
            r += chapter.getUnclaimedRewards(player, data, showExcluded);
        }
        return r;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (quest.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.invalid;
    }

    public QuestShape getDefaultQuestShape() {
        return this.defaultQuestShape == QuestShape.DEFAULT ? this.file.getDefaultQuestShape() : this.defaultQuestShape;
    }
}

