/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.util.IWithID;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum QuestObjectType implements IWithID,
Predicate<QuestObjectBase>
{
    NULL("null", 1, TextFormatting.BLACK),
    FILE("file", 2, TextFormatting.RED),
    CHAPTER("chapter", 4, TextFormatting.GOLD),
    QUEST("quest", 8, TextFormatting.GREEN),
    TASK("task", 16, TextFormatting.BLUE),
    REWARD("reward", 64, TextFormatting.LIGHT_PURPLE),
    REWARD_TABLE("reward_table", 128, TextFormatting.YELLOW);

    public static final NameMap<QuestObjectType> NAME_MAP;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING_OR_NULL;
    private final String id;
    private final String translationKey;
    private final int flag;
    private final TextFormatting color;

    private QuestObjectType(String i, int f, TextFormatting c) {
        this.id = i;
        this.translationKey = "ftbquests." + this.id;
        this.flag = f;
        this.color = c;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getFlag() {
        return this.flag;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
    }

    @Override
    public boolean test(QuestObjectBase object) {
        return (object == null ? NULL : object.getObjectType()) == this;
    }

    static {
        NAME_MAP = NameMap.create((Object)NULL, (Object[])QuestObjectType.values());
        ALL_PROGRESSING = object -> object instanceof QuestObject;
        ALL_PROGRESSING_OR_NULL = object -> object == null || object instanceof QuestObject;
    }
}

