/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.theme;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.theme.QuestTheme;
import com.feed_the_beast.ftbquests.quest.theme.SelectorProperties;
import com.feed_the_beast.ftbquests.quest.theme.selector.AllSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.AndSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.IDSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.NotSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.TagSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.ThemeSelector;
import com.feed_the_beast.ftbquests.quest.theme.selector.TypeSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;

public class ThemeLoader
implements ISelectiveResourceReloadListener {
    public static final IResourceType TYPE = new IResourceType(){};

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(TYPE)) {
            ThemeLoader.loadTheme(resourceManager);
        }
    }

    public static void loadTheme(IResourceManager resourceManager) {
        HashMap<ThemeSelector, SelectorProperties> map = new HashMap<ThemeSelector, SelectorProperties>();
        try {
            for (IResource resource : resourceManager.func_135056_b(new ResourceLocation("ftbquests", "ftb_quests_theme.txt"))) {
                ThemeLoader.parse(map, DataReader.get((IResource)resource).safeStringList());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        QuestTheme theme = new QuestTheme();
        theme.defaults = (SelectorProperties)map.remove(AllSelector.INSTANCE);
        if (theme.defaults == null) {
            theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        }
        theme.selectors.addAll(map.values());
        theme.selectors.sort(null);
        QuestTheme.instance = theme;
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Theme:");
            FTBQuests.LOGGER.info("");
            FTBQuests.LOGGER.info("[*]");
            for (Map.Entry<String, String> entry : theme.defaults.properties.entrySet()) {
                FTBQuests.LOGGER.info(entry.getKey() + ": " + theme.replaceVariables(entry.getValue(), 0));
            }
            for (SelectorProperties selectorProperties : theme.selectors) {
                FTBQuests.LOGGER.info("");
                FTBQuests.LOGGER.info("[" + selectorProperties.selector + "]");
                for (Map.Entry<String, String> entry : selectorProperties.properties.entrySet()) {
                    FTBQuests.LOGGER.info(entry.getKey() + ": " + theme.replaceVariables(entry.getValue(), 0));
                }
            }
        }
    }

    private static void parse(Map<ThemeSelector, SelectorProperties> selectorPropertyMap, List<String> lines) {
        ArrayList<SelectorProperties> current = new ArrayList<SelectorProperties>();
        for (String line : lines) {
            String[] s1;
            int ei;
            int si;
            if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
            if (line.length() > 2 && (si = line.indexOf(91)) < (ei = line.indexOf(93))) {
                current.clear();
                for (String sel : line.substring(si + 1, ei).split("\\|")) {
                    AndSelector andSelector = new AndSelector();
                    for (String sel1 : sel.trim().split("\\&")) {
                        ThemeSelector themeSelector = ThemeLoader.parse(Pattern.compile("\\s").matcher(sel1).replaceAll(""));
                        if (themeSelector == null) continue;
                        andSelector.selectors.add(themeSelector);
                    }
                    if (andSelector.selectors.isEmpty()) continue;
                    AndSelector selector = andSelector.selectors.size() == 1 ? andSelector.selectors.get(0) : andSelector;
                    current.add(selectorPropertyMap.computeIfAbsent(selector, SelectorProperties::new));
                }
                continue;
            }
            if (current.isEmpty() || (s1 = line.split(":", 2)).length != 2) continue;
            String k = s1[0].trim();
            String v = s1[1].trim();
            if (k.isEmpty() || v.isEmpty()) continue;
            for (SelectorProperties selectorProperties : current) {
                selectorProperties.properties.put(k, v);
            }
        }
    }

    @Nullable
    private static ThemeSelector parse(String sel) {
        if (sel.isEmpty()) {
            return null;
        }
        if (sel.equals("*")) {
            return AllSelector.INSTANCE;
        }
        if (sel.startsWith("!")) {
            ThemeSelector s = ThemeLoader.parse(sel.substring(1));
            return s == null ? null : new NotSelector(s);
        }
        if (QuestObjectType.NAME_MAP.map.containsKey(sel)) {
            return new TypeSelector((QuestObjectType)QuestObjectType.NAME_MAP.get(sel));
        }
        if (sel.startsWith("#")) {
            String s = sel.substring(1);
            return s.isEmpty() ? null : new TagSelector(s);
        }
        try {
            return new IDSelector(Long.valueOf(sel, 16).intValue());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

