/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileLootCrateStorage
extends TileBase
implements IItemHandler {
    public Object2IntOpenHashMap<String> crates = new Object2IntOpenHashMap();
    private ItemStack tempLootcrate = new ItemStack(FTBQuestsItems.LOOTCRATE);

    public TileLootCrateStorage() {
    }

    public TileLootCrateStorage(World world) {
        QuestFile file = FTBQuests.PROXY.getQuestFile(world);
        if (file != null && !file.rewardTables.isEmpty()) {
            for (RewardTable table : file.rewardTables) {
                if (table.lootCrate == null || table.lootCrate.stringID.isEmpty()) continue;
                this.crates.put((Object)table.lootCrate.stringID, 0);
            }
        }
    }

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (type.full && !this.crates.isEmpty()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            for (Object2IntMap.Entry entry : this.crates.object2IntEntrySet()) {
                nbt1.func_74768_a((String)entry.getKey(), entry.getIntValue());
            }
            nbt.func_74782_a("crates", (NBTBase)nbt1);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        if (type.full) {
            NBTTagCompound nbt1 = nbt.func_74775_l("crates");
            this.crates = new Object2IntOpenHashMap(nbt1.func_186856_d());
            for (String s : nbt1.func_150296_c()) {
                this.crates.put((Object)s, nbt1.func_74762_e(s));
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    public int getSlots() {
        return 1 + this.crates.size();
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot <= 0 || slot - 1 >= this.crates.size()) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        ObjectIterator iterator = this.crates.object2IntEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            if (slot == i) {
                if (entry.getIntValue() <= 0) {
                    return ItemStack.field_190927_a;
                }
                this.tempLootcrate.func_77983_a("type", (NBTBase)new NBTTagString((String)entry.getKey()));
                this.tempLootcrate.func_190920_e(entry.getIntValue());
                return this.tempLootcrate;
            }
            ++i;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        LootCrate crate = ItemLootCrate.getCrate(this.field_145850_b, stack);
        if (crate == null) {
            return stack;
        }
        if (!simulate && !this.field_145850_b.field_72995_K) {
            this.crates.put((Object)crate.stringID, this.crates.getInt((Object)crate.stringID) + stack.func_190916_E());
            this.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && ItemLootCrate.getCrate(this.field_145850_b, stack) != null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int i = 1;
        ObjectIterator iterator = this.crates.object2IntEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            if (slot == i) {
                if (entry.getIntValue() <= 0) {
                    return ItemStack.field_190927_a;
                }
                int a = Math.min(64, Math.min(entry.getIntValue(), amount));
                ItemStack stack = new ItemStack(FTBQuestsItems.LOOTCRATE);
                stack.func_190920_e(a);
                stack.func_77983_a("type", (NBTBase)new NBTTagString((String)entry.getKey()));
                if (!simulate) {
                    this.crates.put(entry.getKey(), entry.getIntValue() - a);
                    this.func_70296_d();
                }
                return stack;
            }
            ++i;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }
}

