/*
 * Decompiled with CFR 0.152.
 */
package quarris.gce.config.type;

import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;

public class PlayerConfig {
    public SpaceGearConfig spaceGear = new SpaceGearConfig();

    public static class SpaceGearConfig {
        @Config.Comment(value={"Should the player start with the Oxygen Mask equipped?"})
        public boolean oxygenMaskEquipped = false;
        @Config.Comment(value={"Should the player start with the Oxygen Gear equipped?"})
        public boolean oxygenGearEquipped = false;
        @Config.Comment(value={"Should the player start with the Left Oxygen Tank equipped?"})
        public boolean leftOxygenTankEquipped = false;
        @Config.Comment(value={"Should the player start with the Right Oxygen Tank equipped?"})
        public boolean rightOxygenTankEquipped = false;
        @Config.Comment(value={"What Tank Tier should the Left Oxygen Tank be? Only works if enabled"})
        public TankTier leftOxygenTankTier = TankTier.HEAVY;
        @Config.Comment(value={"What Tank Tier should the Right Oxygen Tank be? Only works if enabled"})
        public TankTier rightOxygenTankTier = TankTier.HEAVY;
        @Config.Comment(value={"Should the player start with the Parachute equipped?"})
        public boolean parachuteEquipped = false;
        @Config.Comment(value={"What Color should the Parachute be? Only works if enabled"})
        public ParachuteColor parachuteColor = ParachuteColor.WHITE;
        @Config.Comment(value={"Should the player start with the Frequency Module equipped?"})
        public boolean frequencyModuleEquipped = false;
        @Config.Comment(value={"Should the player start with Thermal Padded Helm?"})
        public boolean thermalHelmEquipped = false;
        @Config.Comment(value={"What Tier should the Thermal Helm be? Only works if enabled"})
        public ThermalTier thermalHelmTier = ThermalTier.BASIC;
        @Config.Comment(value={"Should the player start with Thermal Padded Chestpiece?"})
        public boolean thermalChestpieceEquipped = false;
        @Config.Comment(value={"What Tier should the Thermal Chestpiece be? Only works if enabled"})
        public ThermalTier thermalChestpieceTier = ThermalTier.BASIC;
        @Config.Comment(value={"Should the player start with Thermal Padded Leggings?"})
        public boolean thermalLeggingsEquipped = false;
        @Config.Comment(value={"What Tier should the Thermal Leggings be? Only works if enabled"})
        public ThermalTier thermalLeggingsTier = ThermalTier.BASIC;
        @Config.Comment(value={"Should the player start with Thermal Padded Boots?"})
        public boolean thermalBootsEquipped = false;
        @Config.Comment(value={"What Tier should the Thermal Boots be? Only works if enabled"})
        public ThermalTier thermalBootsTier = ThermalTier.BASIC;
        @Config.Comment(value={"Should the player start with the Shield Controller equipped?"})
        public boolean shieldControllerEquipped = false;

        public static enum ParachuteColor {
            WHITE,
            BLACK,
            LIGHT_BLUE,
            LIME,
            BROWN,
            BLUE,
            GRAY,
            GREEN,
            LIGHT_GRAY,
            MAGENTA,
            ORANGE,
            PINK,
            PURPLE,
            RED,
            CYAN,
            YELLOW;

        }

        public static enum TankTier {
            LIGHT,
            MEDIUM,
            HEAVY,
            INFINITE;


            public ItemStack getItemStack() {
                switch (this) {
                    case LIGHT: {
                        return new ItemStack(GCItems.oxTankLight);
                    }
                    case MEDIUM: {
                        return new ItemStack(GCItems.oxTankMedium);
                    }
                    case HEAVY: {
                        return new ItemStack(GCItems.oxTankHeavy);
                    }
                    case INFINITE: {
                        return new ItemStack(GCItems.oxygenCanisterInfinite);
                    }
                }
                return ItemStack.field_190927_a;
            }
        }

        public static enum ThermalTier {
            BASIC,
            ISOTHERMIC;


            public ItemStack getItemStack(int meta) {
                switch (this) {
                    case BASIC: {
                        return new ItemStack(AsteroidsItems.thermalPadding, 1, meta);
                    }
                    case ISOTHERMIC: {
                        return new ItemStack(VenusItems.thermalPaddingTier2, 1, meta);
                    }
                }
                return ItemStack.field_190927_a;
            }
        }
    }
}

