/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.fluid.IFluidCoolant;
import crazypants.enderio.base.fluid.IFluidFuel;
import java.util.Map;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import shadows.endertweaker.EnderTweaker;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.CombustionGen")
@ZenRegister
public class CombustionGen {
    private static final Map<String, IFluidCoolant> coolants = (Map)ObfuscationReflectionHelper.getPrivateValue(FluidFuelRegister.class, (Object)FluidFuelRegister.instance, (String[])new String[]{"coolants"});
    private static final Map<String, IFluidFuel> fuels = (Map)ObfuscationReflectionHelper.getPrivateValue(FluidFuelRegister.class, (Object)FluidFuelRegister.instance, (String[])new String[]{"fuels"});

    @ZenMethod
    public static void addFuel(ILiquidStack fuel, int powerPerCycleRF, int totalBurnTime) {
        EnderTweaker.ADDITIONS.add(() -> FluidFuelRegister.instance.addFuel(CraftTweakerMC.getLiquidStack((ILiquidStack)fuel).getFluid(), powerPerCycleRF, totalBurnTime));
    }

    @ZenMethod
    public static void addCoolant(ILiquidStack coolant, float degreesCoolingPerMB) {
        EnderTweaker.ADDITIONS.add(() -> FluidFuelRegister.instance.addCoolant(CraftTweakerMC.getLiquidStack((ILiquidStack)coolant).getFluid(), degreesCoolingPerMB));
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack fuel) {
        if (fuel == null) {
            CraftTweakerAPI.logError((String)"Cannot remove null fuel.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> fuels.remove(fuel.getName()));
    }

    @ZenMethod
    public static void removeCoolant(ILiquidStack coolant) {
        if (coolant == null) {
            CraftTweakerAPI.logError((String)"Cannot remove null coolant.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> coolants.remove(coolant.getName()));
    }
}

