/*
 * Decompiled with CFR 0.152.
 */
package lumien.nonausea.asm;

import java.io.File;
import lumien.nonausea.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"NoNausea");
    int mode;

    public ClassTransformer() {
        File f = new File("config/NoNausea.cfg");
        Configuration config = new Configuration(f);
        config.load();
        this.mode = config.get("Settings", "Mode", 1, "0: No Effect at all, 1: Invert left and right, 2: Invert left/right and forward/backwards, 3: Slightly tilt camera").getInt(1);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            return this.patchClientPlayerClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer") && this.mode == 3) {
            return this.patchEntityRendererClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.util.MovementInputFromOptions") && (this.mode == 1 || this.mode == 2)) {
            return this.patchMovementInputClass(basicClass);
        }
        return basicClass;
    }

    private byte[] patchMovementInputClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found MovementInput Class: " + classNode.name);
        MethodNode updateMove = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78898_a"))) continue;
            updateMove = mn;
            break;
        }
        int counter = 0;
        if (updateMove != null) {
            this.logger.log(Level.DEBUG, " - Found updatePlayerMoveState()");
            for (int i = 0; i < updateMove.instructions.size(); ++i) {
                InsnNode in;
                AbstractInsnNode ain = updateMove.instructions.get(i);
                if (!(ain instanceof InsnNode) || (in = (InsnNode)ain).getOpcode() != 12) continue;
                if (counter == 0 && this.mode == 2) {
                    updateMove.instructions.insert((AbstractInsnNode)in, (AbstractInsnNode)new MethodInsnNode(184, "lumien/nonausea/NoNausea", "forward", "()F", false));
                    updateMove.instructions.remove((AbstractInsnNode)in);
                    this.logger.log(Level.DEBUG, " - Patched 1/4");
                } else if (counter == 1 && this.mode == 2) {
                    updateMove.instructions.insert((AbstractInsnNode)in, (AbstractInsnNode)new MethodInsnNode(184, "lumien/nonausea/NoNausea", "backwards", "()F", false));
                    updateMove.instructions.remove((AbstractInsnNode)in);
                    this.logger.log(Level.DEBUG, " - Patched 2/4");
                } else if (counter == 3) {
                    updateMove.instructions.insert((AbstractInsnNode)in, (AbstractInsnNode)new MethodInsnNode(184, "lumien/nonausea/NoNausea", "left", "()F", false));
                    updateMove.instructions.remove((AbstractInsnNode)in);
                    this.logger.log(Level.DEBUG, " - Patched 4/4");
                } else if (counter == 2) {
                    updateMove.instructions.insert((AbstractInsnNode)in, (AbstractInsnNode)new MethodInsnNode(184, "lumien/nonausea/NoNausea", "right", "()F", false));
                    updateMove.instructions.remove((AbstractInsnNode)in);
                    this.logger.log(Level.DEBUG, " - Patched 3/4");
                }
                ++counter;
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRendererClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityRenderer Class: " + classNode.name);
        MethodNode camera = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78479_a"))) continue;
            camera = mn;
            break;
        }
        if (camera != null) {
            this.logger.log(Level.DEBUG, " - Found setupCameraTransform()");
            for (int i = 0; i < camera.instructions.size(); ++i) {
                AbstractInsnNode ain = camera.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_78467_g"))) continue;
                this.logger.log(Level.DEBUG, " - Inserting camera hook");
                camera.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, "lumien/nonausea/NoNausea", "orientCamera", "()V", false));
                break;
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClientPlayerClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityPlayerSP Class: " + classNode.name);
        MethodNode update = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_70636_d"))) continue;
            update = mn;
            break;
        }
        if (update != null) {
            this.logger.log(Level.DEBUG, " - Found onLivingUpdate()");
            for (int i = 0; i < update.instructions.size(); ++i) {
                AbstractInsnNode ain = update.instructions.get(i);
                if (!(ain instanceof LdcInsnNode)) continue;
                LdcInsnNode li = (LdcInsnNode)ain;
                if (!li.cst.equals(new Float("0.006666667"))) continue;
                this.logger.log(Level.DEBUG, " - Patching Vanilla Nausea Effect");
                li.cst = new Float("0.0");
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

