/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.blocks;

import exnihilocreatio.ModBlocks;
import exnihilocreatio.blocks.BlockInfestedLeaves;
import exnihilocreatio.compatibility.ITOPInfoProvider;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.ITileLeafBlock;
import exnihilocreatio.tiles.TileInfestingLeaves;
import exnihilocreatio.util.Data;
import exnihilocreatio.util.IHasModel;
import exnihilocreatio.util.ItemUtil;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockInfestingLeaves
extends BlockLeaves
implements ITileEntityProvider,
ITOPInfoProvider,
IHasModel {
    public static final PropertyBool NEARBYLEAVES = PropertyBool.func_177716_a((String)"nearby_leaves");
    public static final IUnlistedProperty<IBlockState> LEAFBLOCK = new IUnlistedProperty<IBlockState>(){

        public String getName() {
            return "LeafBlock";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    };

    public BlockInfestingLeaves() {
        this(InfestedType.INFESTING);
        this.func_149663_c("block_infesting_leaves");
        this.setRegistryName("block_infesting_leaves");
        Data.BLOCKS.add((Block)this);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NEARBYLEAVES, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockInfestingLeaves(InfestedType type) {
        this.func_149675_a(true);
        this.field_185686_c = true;
    }

    public static void infestLeafBlock(World world, IBlockState state, BlockPos pos) {
        IBlockState leafState = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b().equalsIgnoreCase("forestry") ? Blocks.field_150362_t.func_176223_P() : state;
        Boolean check_decay = leafState.func_177227_a().contains(field_176236_b) ? (Boolean)leafState.func_177229_b((IProperty)field_176236_b) : Boolean.valueOf(false);
        Boolean decayable = leafState.func_177227_a().contains(field_176237_a) ? (Boolean)leafState.func_177229_b((IProperty)field_176237_a) : Boolean.valueOf(false);
        world.func_180501_a(pos, ModBlocks.infestingLeaves.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)check_decay).func_177226_a((IProperty)field_176237_a, (Comparable)decayable), 3);
        if (world.func_175625_s(pos) != null) {
            ((ITileLeafBlock)world.func_175625_s(pos)).setLeafBlock(leafState);
        }
    }

    public static void setInfested(World world, BlockPos pos, IBlockState leafState) {
        IBlockState block = world.func_180495_p(pos);
        if (block.func_177230_c() instanceof BlockInfestingLeaves) {
            IBlockState retval = ModBlocks.infestedLeaves.func_176223_P().func_177226_a((IProperty)field_176236_b, block.func_177229_b((IProperty)field_176236_b)).func_177226_a((IProperty)field_176237_a, block.func_177229_b((IProperty)field_176237_a));
            retval = ((IExtendedBlockState)retval).withProperty(BlockInfestedLeaves.LEAFBLOCK, (Object)leafState);
            world.func_180501_a(pos, retval, 7);
            if (world.func_175625_s(pos) != null) {
                ((ITileLeafBlock)world.func_175625_s(pos)).setLeafBlock(leafState);
                ((BaseTileEntity)world.func_175625_s(pos)).markDirtyClient();
            }
        } else if (Util.isLeaves(block) && !(block.func_177230_c() instanceof BlockInfestedLeaves)) {
            LogUtil.error("Sent leaf change to wrong method, redirecting");
            BlockInfestingLeaves.infestLeafBlock(world, block, pos);
        }
    }

    public static void spread(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state != null && ((Boolean)state.func_177229_b((IProperty)NEARBYLEAVES)).booleanValue()) {
            NonNullList<BlockPos> nearbyLeaves = Util.getNearbyLeaves(world, pos);
            if (nearbyLeaves.isEmpty()) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)NEARBYLEAVES, (Comparable)Boolean.valueOf(false)), 7);
            } else {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileInfestingLeaves && ((TileInfestingLeaves)te).getProgress() > ModConfig.infested_leaves.leavesSpreadPercent) {
                    nearbyLeaves.stream().filter(leaves -> rand.nextFloat() <= ModConfig.infested_leaves.leavesSpreadChanceFloat).findAny().ifPresent(blockPos -> BlockInfestingLeaves.infestLeafBlock(world, world.func_180495_p(blockPos), blockPos));
                }
            }
        }
    }

    public static IBlockState getLeafState(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            return (IBlockState)((IExtendedBlockState)state).getValue(BlockInfestedLeaves.LEAFBLOCK);
        }
        return state;
    }

    public void func_180645_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        this.func_180650_b(world, pos, state, rand);
        BlockInfestingLeaves.spread(world, pos, state, rand);
    }

    public int func_149738_a(World worldIn) {
        return ModConfig.infested_leaves.leavesUpdateFrequency;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && Util.isLeaves(worldIn.func_180495_p(fromPos))) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)NEARBYLEAVES, (Comparable)Boolean.valueOf(true)), 7);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            IBlockState leafState = te instanceof ITileLeafBlock ? ((ITileLeafBlock)te).getLeafBlock() : Blocks.field_150362_t.func_176223_P();
            return retval.withProperty(LEAFBLOCK, (Object)leafState);
        }
        return state;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{field_176236_b, field_176237_a, NEARBYLEAVES};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{LEAFBLOCK};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 2) != 0)).func_177226_a((IProperty)NEARBYLEAVES, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int checkDecay = (Boolean)state.func_177229_b((IProperty)field_176236_b) != false ? 1 : 0;
        int decayable = (Boolean)state.func_177229_b((IProperty)field_176237_a) != false ? 1 : 0;
        int nearbyLeaves = (Boolean)state.func_177229_b((IProperty)NEARBYLEAVES) != false ? 1 : 0;
        return checkDecay << 2 | decayable << 1 | nearbyLeaves;
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    @Nonnull
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileInfestingLeaves();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        if (!world.field_72995_K && !player.func_184812_l_() && (tile = world.func_175625_s(pos)) != null) {
            if (tile instanceof ITileLeafBlock) {
                ITileLeafBlock leaves = (ITileLeafBlock)tile;
                if (ItemUtil.isCrook(player.func_184614_ca())) {
                    if ((double)world.field_73012_v.nextFloat() < (double)leaves.getProgress() * ModConfig.crooking.stringChance / 100.0) {
                        Util.dropItemInWorld(tile, player, new ItemStack(Items.field_151007_F, world.field_73012_v.nextInt(ModConfig.crooking.maxStringDrop) + 1, 0), 0.02f);
                    }
                } else if ((double)world.field_73012_v.nextFloat() * 100.0 < (double)leaves.getProgress() * ModConfig.crooking.stringChance / 4.0 / 100.0) {
                    Util.dropItemInWorld(tile, player, new ItemStack(Items.field_151007_F, 1, 0), 0.02f);
                }
            }
            world.func_175713_t(pos);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileInfestingLeaves tile = (TileInfestingLeaves)world.func_175625_s(data.getPos());
        if (tile != null) {
            if (tile.getProgress() >= 100) {
                probeInfo.text("Progress: Done");
            } else {
                probeInfo.progress(tile.getProgress(), 100);
            }
        }
    }

    static enum InfestedType {
        INFESTING,
        INFESTED;

    }
}

