/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.client.color;

import exnihilocreatio.client.color.ColorThief;
import exnihilocreatio.util.ItemInfo;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public final class ColorGetter {
    public static final HashMap<ItemInfo, exnihilocreatio.texturing.Color> colorCache = new HashMap();

    private ColorGetter() {
    }

    public static exnihilocreatio.texturing.Color getColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return exnihilocreatio.texturing.Color.INVALID_COLOR;
        }
        ItemInfo info = new ItemInfo(stack);
        if (colorCache.containsKey(info)) {
            return colorCache.get(info);
        }
        List<Color> color = ColorGetter.getColors(stack, 1);
        if (color.size() > 0) {
            Color domColor = color.get(0);
            exnihilocreatio.texturing.Color exColor = new exnihilocreatio.texturing.Color(domColor.getRGB());
            colorCache.put(info, exColor);
            return exColor;
        }
        return exnihilocreatio.texturing.Color.INVALID_COLOR;
    }

    public static List<Color> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException ignored) {
            return Collections.emptyList();
        }
    }

    private static List<Color> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.func_77973_b();
        if (itemStack.func_190926_b()) {
            return Collections.emptyList();
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(itemStack, block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Color> getItemColors(ItemStack itemStack, int colorCount) {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        int renderColor = itemColors.func_186728_a(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Color> getBlockColors(ItemStack itemStack, Block block, int colorCount) {
        IBlockState blockState;
        int meta = itemStack.func_77960_j();
        try {
            blockState = block.func_176203_a(meta);
        }
        catch (LinkageError | RuntimeException ignored) {
            blockState = block.func_176223_P();
        }
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int renderColor = blockColors.func_186724_a(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public static List<Color> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        BufferedImage bufferedImage = ColorGetter.getBufferedImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Color> colors = new ArrayList<Color>(colorCount);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
                green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
                blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
                Color color = new Color(red, green, blue);
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        if (textureAtlasSprite == minecraft.func_147117_R().func_174944_f()) {
            return null;
        }
        return textureAtlasSprite;
    }

    @NotNull
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemModelMesher itemModelMesher = renderItem.func_175037_a();
        IBakedModel itemModel = itemModelMesher.func_178089_a(itemStack);
        return itemModel.func_177554_e();
    }
}

