/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exnihilocreatio.compatibility.crafttweaker.CrTIntegration;
import exnihilocreatio.compatibility.crafttweaker.prefab.ENCRemoveAll;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.HammerRegistry;
import exnihilocreatio.registries.types.HammerReward;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilocreatio.Hammer")
@ZenRegister
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/compatibility/crafttweaker/Hammer;", "", "()V", "addRecipe", "", "block", "Lcrafttweaker/api/item/IIngredient;", "drop", "Lcrafttweaker/api/item/IItemStack;", "miningLevel", "", "chance", "", "fortuneChance", "removeAll", "AddRecipe", "exnihilocreatio"})
public final class Hammer {
    public static final Hammer INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void removeAll() {
        Collection collection = CrTIntegration.removeActions;
        HammerRegistry hammerRegistry = ExNihiloRegistryManager.HAMMER_REGISTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)hammerRegistry, (String)"ExNihiloRegistryManager.HAMMER_REGISTRY");
        ENCRemoveAll eNCRemoveAll = new ENCRemoveAll(hammerRegistry, "Hammer");
        collection.add(eNCRemoveAll);
    }

    @ZenMethod
    @JvmStatic
    public static final void addRecipe(@NotNull IIngredient block, @NotNull IItemStack drop, int miningLevel, float chance, float fortuneChance) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)drop, (String)"drop");
        Collection collection = CrTIntegration.addActions;
        AddRecipe addRecipe = new AddRecipe(block, drop, miningLevel, chance, fortuneChance);
        collection.add(addRecipe);
    }

    private Hammer() {
    }

    static {
        Hammer hammer;
        INSTANCE = hammer = new Hammer();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lexnihilocreatio/compatibility/crafttweaker/Hammer$AddRecipe;", "Lcrafttweaker/IAction;", "block", "Lcrafttweaker/api/item/IIngredient;", "drop", "Lcrafttweaker/api/item/IItemStack;", "miningLevel", "", "chance", "", "fortuneChance", "(Lcrafttweaker/api/item/IIngredient;Lcrafttweaker/api/item/IItemStack;IFF)V", "input", "Lnet/minecraft/item/crafting/Ingredient;", "apply", "", "describe", "", "exnihilocreatio"})
    private static final class AddRecipe
    implements IAction {
        private final Ingredient input;
        private final IItemStack drop;
        private final int miningLevel;
        private final float chance;
        private final float fortuneChance;

        public void apply() {
            Object object = this.drop.getInternal();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.item.ItemStack");
            }
            ExNihiloRegistryManager.HAMMER_REGISTRY.register(this.input, new HammerReward((ItemStack)object, this.miningLevel, this.chance, this.fortuneChance));
        }

        @NotNull
        public String describe() {
            StringBuilder stringBuilder = new StringBuilder().append("Adding Hammer recipe for ");
            Object[] objectArray = this.input.func_193365_a();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"input.matchingStacks");
            return stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null)).append(" with drop ").append(this.drop).append(" at a chance of ").append(this.chance).append(" with mining level ").append(this.miningLevel).toString();
        }

        public AddRecipe(@NotNull IIngredient block, @NotNull IItemStack drop, int miningLevel, float chance, float fortuneChance) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            Intrinsics.checkParameterIsNotNull((Object)drop, (String)"drop");
            this.drop = drop;
            this.miningLevel = miningLevel;
            this.chance = chance;
            this.fortuneChance = fortuneChance;
            Ingredient ingredient = CraftTweakerMC.getIngredient((IIngredient)block);
            Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"CraftTweakerMC.getIngredient(block)");
            this.input = ingredient;
        }
    }
}

