/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.util.BlockInfo;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomMeltableJson;", "Lcom/google/gson/JsonDeserializer;", "Lexnihilocreatio/registries/types/Meltable;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomMeltableJson
implements JsonDeserializer<Meltable>,
JsonSerializer<Meltable> {
    public static final CustomMeltableJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull Meltable src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", src.getFluid());
        obj.addProperty("amount", (Number)src.getAmount());
        if (Intrinsics.areEqual((Object)src.getTextureOverride(), (Object)BlockInfo.EMPTY) ^ true) {
            obj.add("color", context.serialize((Object)src.getTextureOverride(), (Type)((Object)BlockInfo.class)));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public Meltable deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonHelper helper = new JsonHelper(json);
        JsonObject obj = json.getAsJsonObject();
        String fluid = helper.getString("fluid");
        int amount = helper.getInteger("amount");
        BlockInfo textureOverride = BlockInfo.EMPTY;
        if (obj.has("textureOverride")) {
            textureOverride = (BlockInfo)context.deserialize(json.getAsJsonObject().get("textureOverride"), (Type)((Object)BlockInfo.class));
        }
        String string = fluid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fluid");
        BlockInfo blockInfo = textureOverride;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockInfo, (String)"textureOverride");
        return new Meltable(string, amount, blockInfo);
    }

    private CustomMeltableJson() {
    }

    static {
        CustomMeltableJson customMeltableJson;
        INSTANCE = customMeltableJson = new CustomMeltableJson();
    }
}

